/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.osgi.rest.resources;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.osgi.Service;
import com.atlassian.upm.osgi.ServiceAccessor;
import com.atlassian.upm.rest.representations.UpmRepresentationFactory;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import java.util.Objects;

@AdminOnly
@Path(value="/services/{id}")
public class ServiceResource {
    private final ServiceAccessor serviceAccessor;
    private final UpmRepresentationFactory representationFactory;
    private final PermissionEnforcer permissionEnforcer;

    @Inject
    public ServiceResource(ServiceAccessor serviceAccessor, UpmRepresentationFactory representationFactory, PermissionEnforcer permissionEnforcer) {
        this.serviceAccessor = Objects.requireNonNull(serviceAccessor, "serviceAccessor");
        this.representationFactory = Objects.requireNonNull(representationFactory, "representationFactory");
        this.permissionEnforcer = Objects.requireNonNull(permissionEnforcer, "permissionEnforcer");
    }

    @GET
    public Response get(@PathParam(value="id") long id) {
        this.permissionEnforcer.enforcePermission(Permission.GET_OSGI_STATE);
        Service service = this.serviceAccessor.getService(id);
        if (service != null) {
            return Response.ok((Object)this.representationFactory.createOsgiServiceRepresentation(service)).type("application/vnd.atl.plugins.osgi.service+json").build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

