/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.pac;

import com.atlassian.marketplace.client.model.ApplicationVersion;
import com.atlassian.marketplace.client.model.ApplicationVersionStatus;
import com.atlassian.marketplace.parentsoftware.model.ParentSoftwareVersionGetResponse;
import java.time.ZoneOffset;

public class LegacyPacClientMapper {
    private LegacyPacClientMapper() {
    }

    public static ParentSoftwareVersionGetResponse mapApplicationVersionToParentSoftwareVersionGetResponse(ApplicationVersion applicationVersion) {
        if (applicationVersion == null) {
            return null;
        }
        ParentSoftwareVersionGetResponse parentSoftwareVersionGetResponse = new ParentSoftwareVersionGetResponse();
        parentSoftwareVersionGetResponse.setBuildNumber(Long.valueOf(applicationVersion.getBuildNumber()));
        parentSoftwareVersionGetResponse.setVersionNumber(applicationVersion.getName());
        parentSoftwareVersionGetResponse.setState(LegacyPacClientMapper.mapStatusToState(applicationVersion.getStatus()));
        parentSoftwareVersionGetResponse.createdAt(applicationVersion.getLocalReleaseDate().atStartOfDay().atOffset(ZoneOffset.UTC));
        if (applicationVersion.isDataCenterCompatible()) {
            parentSoftwareVersionGetResponse.addHostingItem(ParentSoftwareVersionGetResponse.HostingEnum.DATACENTER);
        }
        parentSoftwareVersionGetResponse.addHostingItem(ParentSoftwareVersionGetResponse.HostingEnum.SERVER);
        return parentSoftwareVersionGetResponse;
    }

    private static ParentSoftwareVersionGetResponse.StateEnum mapStatusToState(ApplicationVersionStatus status) {
        if (status == null) {
            return null;
        }
        return switch (status) {
            default -> throw new MatchException(null, null);
            case ApplicationVersionStatus.PUBLISHED -> ParentSoftwareVersionGetResponse.StateEnum.ACTIVE;
            case ApplicationVersionStatus.UNPUBLISHED -> ParentSoftwareVersionGetResponse.StateEnum.DRAFT;
        };
    }
}

