/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.pac;

import com.atlassian.cache.Supplier;
import com.atlassian.marketplace.client.model.ApplicationVersion;
import com.atlassian.marketplace.parentsoftware.model.ParentSoftwareVersionGetResponse;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.upm.ApplicationKeyUtils;
import com.atlassian.upm.UpmHostApplicationInformation;
import com.atlassian.upm.core.pac.ParentSoftwareClientManager;
import com.atlassian.upm.pac.MpacApplication;
import java.util.Objects;
import java.util.Optional;

public class MpacParentSoftwareSupplier
implements Supplier<Optional<MpacApplication>> {
    private final ApplicationProperties applicationProperties;
    private final ParentSoftwareClientManager parentSoftwareClientManager;
    private final UpmHostApplicationInformation hostApplicationInformation;

    public MpacParentSoftwareSupplier(ApplicationProperties applicationProperties, ParentSoftwareClientManager parentSoftwareClientManager, UpmHostApplicationInformation hostApplicationInformation) {
        this.applicationProperties = Objects.requireNonNull(applicationProperties);
        this.parentSoftwareClientManager = Objects.requireNonNull(parentSoftwareClientManager);
        this.hostApplicationInformation = Objects.requireNonNull(hostApplicationInformation);
    }

    public Optional<MpacApplication> get() {
        return this.fetchMpacAppInfoForLocalBuild().or(this::fetchMpacAppInfoForLatest);
    }

    private Optional<MpacApplication> fetchMpacAppInfoForLatest() {
        if (this.hostApplicationInformation.isDevelopmentProductVersion()) {
            return this.toMpacInfo(this.parentSoftwareClientManager.getParentSoftwareClient().safeGetLatestParentSoftwareVersion(this.getMarketplaceApplicationKey()), true);
        }
        return Optional.empty();
    }

    private Optional<MpacApplication> fetchMpacAppInfoForLocalBuild() {
        Long buildNumber = this.hostApplicationInformation.getBuildNumber();
        return this.toMpacInfo(this.parentSoftwareClientManager.getParentSoftwareClient().safeGetParentSoftwareVersionByBuildNumber(this.getMarketplaceApplicationKey(), buildNumber), false);
    }

    private String getMarketplaceApplicationKey() {
        return ApplicationKeyUtils.getMarketplaceApplicationKey(this.applicationProperties.getDisplayName());
    }

    private Optional<MpacApplication> toMpacInfo(Optional<ParentSoftwareVersionGetResponse> maybe, boolean unknown) {
        return maybe.map(av -> new MpacApplication(unknown, av.getBuildNumber())).or(this::unknownMpacApplication);
    }

    private Optional<MpacApplication> unknownMpacApplication() {
        return this.hostApplicationInformation.isDevelopmentProductVersion() ? Optional.empty() : Optional.of(new MpacApplication(true, null));
    }

    private Optional<MpacApplication> applicationVersionToMpacInfo(Optional<ApplicationVersion> version, boolean unknown) {
        return version.map(av -> new MpacApplication(unknown, av.getBuildNumber())).or(this::unknownMpacApplication);
    }
}

