/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.rest.resources;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.marketplace.client.MpacException;
import com.atlassian.sal.api.websudo.WebSudoNotRequired;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.pac.PacClient;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LicensedOnly
@Path(value="/categories")
@WebSudoNotRequired
public class CategoryCollectionResource {
    private final PacClient client;
    private final PermissionEnforcer permissionEnforcer;
    private static final Logger log = LoggerFactory.getLogger(CategoryCollectionResource.class);

    @Inject
    public CategoryCollectionResource(PacClient client, PermissionEnforcer permissionEnforcer) {
        this.permissionEnforcer = Objects.requireNonNull(permissionEnforcer, "permissionEnforcer");
        this.client = Objects.requireNonNull(client, "client");
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins.categories+json"})
    public Response get() {
        this.permissionEnforcer.enforcePermission(Permission.GET_AVAILABLE_PLUGINS);
        try {
            return Response.ok(this.client.getCategories()).build();
        }
        catch (MpacException e) {
            log.warn("Failed to get categories", (Throwable)e);
            return Response.serverError().build();
        }
    }
}

