/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.rest.resources;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.upm.SafeModeService;
import com.atlassian.upm.core.PluginsEnablementState;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Objects;

@AdminOnly
@Path(value="/enablement-state")
public class EnablementStateResource {
    private final SafeModeService safeMode;
    private final PermissionEnforcer permissionEnforcer;

    @Inject
    public EnablementStateResource(SafeModeService safeMode, PermissionEnforcer permissionEnforcer) {
        this.permissionEnforcer = Objects.requireNonNull(permissionEnforcer, "permissionEnforcer");
        this.safeMode = Objects.requireNonNull(safeMode, "safeMode");
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins+json"})
    public Response getEnablementState() {
        this.permissionEnforcer.enforcePermission(Permission.GET_SAFE_MODE);
        return Response.ok((Object)this.safeMode.getCurrentConfiguration()).build();
    }

    @PUT
    @Consumes(value={"application/vnd.atl.plugins+json"})
    public Response putEnablementState(PluginsEnablementState config) {
        this.permissionEnforcer.enforcePermission(Permission.MANAGE_SAFE_MODE);
        this.safeMode.applyConfiguration(config);
        return Response.ok().build();
    }
}

