/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.rest.resources;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.marketplace.client.MpacException;
import com.atlassian.marketplace.parentsoftware.model.ParentSoftwareVersionGetResponse;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.resources.RequestContext;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.pac.PacClient;
import com.atlassian.upm.rest.representations.UpmRepresentationFactory;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;

@SystemAdminOnly
@Path(value="/product-updates")
public class ProductUpdatesResource {
    private final UpmRepresentationFactory representationFactory;
    private final PacClient client;
    private final PermissionEnforcer permissionEnforcer;

    @Inject
    public ProductUpdatesResource(UpmRepresentationFactory factory, PacClient client, PermissionEnforcer permissionEnforcer) {
        this.permissionEnforcer = Objects.requireNonNull(permissionEnforcer, "permissionEnforcer");
        this.representationFactory = Objects.requireNonNull(factory, "representationFactory");
        this.client = Objects.requireNonNull(client, "client");
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins.product.updates+json"})
    public Response get(@Context HttpServletRequest request) {
        this.permissionEnforcer.enforcePermission(Permission.GET_PRODUCT_UPDATE_COMPATIBILITY);
        ArrayList<ParentSoftwareVersionGetResponse> parentSoftwareVersions = new ArrayList();
        boolean pacUnreachable = !this.client.isPacReachable();
        try {
            parentSoftwareVersions = this.client.getProductUpdates();
        }
        catch (MpacException e) {
            parentSoftwareVersions = Collections.emptyList();
            pacUnreachable = true;
        }
        return Response.ok((Object)this.representationFactory.createProductUpdatesRepresentation(parentSoftwareVersions, new RequestContext(request).pacUnreachable(pacUnreachable))).build();
    }
}

