/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.rest.resources.disableall;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.upm.UpmInformation;
import com.atlassian.upm.core.PluginEnablementService;
import com.atlassian.upm.core.PluginRetriever;
import com.atlassian.upm.core.async.AsyncTaskInfo;
import com.atlassian.upm.core.async.AsynchronousTaskManager;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.BaseUriBuilder;
import com.atlassian.upm.core.rest.async.AsyncTaskRepresentationFactory;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.pac.PacClient;
import com.atlassian.upm.rest.resources.disableall.DisableAllIncompatibleTask;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.Objects;

@AdminOnly
@Path(value="/incompatible/disable-all")
public class DisableAllIncompatibleResource {
    private final AsynchronousTaskManager taskManager;
    private final BaseUriBuilder uriBuilder;
    private final PacClient pacClient;
    private final PluginEnablementService enabler;
    private final PluginRetriever pluginRetriever;
    private final PermissionEnforcer permissionEnforcer;
    private final UpmInformation upm;
    private final AsyncTaskRepresentationFactory taskRepresentationFactory;

    @Inject
    public DisableAllIncompatibleResource(AsynchronousTaskManager taskManager, AsyncTaskRepresentationFactory taskRepresentationFactory, BaseUriBuilder uriBuilder, PacClient pacClient, PluginEnablementService enabler, PluginRetriever pluginRetriever, PermissionEnforcer permissionEnforcer, UpmInformation upm) {
        this.taskManager = Objects.requireNonNull(taskManager, "taskManager");
        this.uriBuilder = Objects.requireNonNull(uriBuilder, "uriBuilder");
        this.taskRepresentationFactory = Objects.requireNonNull(taskRepresentationFactory, "taskRepresentationFactory");
        this.pacClient = Objects.requireNonNull(pacClient, "pacClient");
        this.enabler = Objects.requireNonNull(enabler, "enabler");
        this.pluginRetriever = Objects.requireNonNull(pluginRetriever, "pluginRetriever");
        this.permissionEnforcer = Objects.requireNonNull(permissionEnforcer, "permissionEnforcer");
        this.upm = Objects.requireNonNull(upm, "upm");
    }

    @POST
    @Consumes(value={"application/vnd.atl.plugins.disableall+json"})
    public Response disableAll() {
        this.permissionEnforcer.enforcePermission(Permission.DISABLE_ALL_USER_INSTALLED);
        DisableAllIncompatibleTask task = new DisableAllIncompatibleTask(this.pacClient, this.enabler, this.pluginRetriever, this.upm);
        AsyncTaskInfo taskInfo = this.taskManager.executeAsynchronousTask(task);
        return this.taskRepresentationFactory.createLegacyAsyncTaskRepresentation(taskInfo).toNewlyCreatedResponse(this.uriBuilder);
    }
}

