/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.schedule;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.Message;
import com.atlassian.upm.api.log.AuditLogEntry;
import com.atlassian.upm.api.log.EntryType;
import com.atlassian.upm.core.log.AuditLogService;
import com.atlassian.upm.schedule.AbstractUpmScheduledJob;
import com.atlassian.upm.schedule.UpmScheduler;
import com.atlassian.upm.signing.api.config.UpmConfig;
import com.atlassian.upm.signing.api.config.UpmConfigStatus;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpmConfigCheckJob
extends AbstractUpmScheduledJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpmConfigCheckJob.class);
    private static final Duration DEFAULT_INTERVAL = Duration.ofMinutes(15L);
    private final UpmConfig upmConfig;
    private final AuditLogService auditLogService;
    private final I18nResolver i18nResolver;
    private final Duration repeatInterval;

    public UpmConfigCheckJob(UpmScheduler upmScheduler, UpmConfig upmConfig, AuditLogService auditLogService, I18nResolver i18nResolver) {
        super(upmScheduler);
        this.upmConfig = upmConfig;
        this.auditLogService = auditLogService;
        this.i18nResolver = i18nResolver;
        this.repeatInterval = Optional.ofNullable(upmConfig.getSafetyCheckInterval()).flatMap(this::getRepeatInterval).orElse(DEFAULT_INTERVAL);
    }

    private Optional<Duration> getRepeatInterval(String property) {
        try {
            return Optional.of(Duration.parse(property));
        }
        catch (Exception e) {
            LOGGER.warn("Error parsing duration property {} : {}", (Object)property, (Object)e.getMessage());
            return Optional.empty();
        }
    }

    @Override
    public Optional<Duration> getRepeatInterval() {
        return Optional.of(this.repeatInterval);
    }

    @Override
    protected void executeInternal(UpmScheduler.RunMode runMode) throws Exception {
        if (this.upmConfig.isPluginSigningEnabled()) {
            UpmConfigStatus status = this.upmConfig.safetyCheckStatus();
            this.getLastAuditLogStatus().ifPresentOrElse(prev -> this.auditLog(status, (UpmConfigStatus.Status)((Object)prev)), () -> this.auditLog(status));
        }
    }

    private void auditLog(UpmConfigStatus status, UpmConfigStatus.Status previous) {
        if (previous != null && previous != status.status()) {
            this.auditLogService.logI18nMessageWithCurrentApplication("upm.auditLog.config.healthcheck.changed", status.status().name(), previous.name());
            this.auditLog(status);
        }
    }

    private void auditLog(UpmConfigStatus status) {
        if (status.success()) {
            LOGGER.info(status.getDescription());
        } else {
            LOGGER.warn(status.getDescription());
        }
        switch (status.status()) {
            case FAILURE: {
                this.auditLogService.logI18nMessageWithCurrentApplication("upm.auditLog.config.healthcheck.error", this.inlineMessages(status.getErrors()));
                break;
            }
            case WARNING: {
                this.auditLogService.logI18nMessageWithCurrentApplication("upm.auditLog.config.healthcheck.warning", this.inlineMessages(status.getWarnings()));
                break;
            }
            case SUCCESS: {
                this.auditLogService.logI18nMessageWithCurrentApplication("upm.auditLog.config.healthcheck.success", new String[0]);
            }
        }
    }

    private Optional<UpmConfigStatus.Status> getLastAuditLogStatus() {
        Iterator<AuditLogEntry> entries = this.auditLogService.getLogEntries(1, null, Set.of(EntryType.CONFIG_HEALTHCHECK)).iterator();
        if (entries.hasNext()) {
            return Optional.of(switch (entries.next().getI18nKey()) {
                case "upm.auditLog.config.healthcheck.error" -> UpmConfigStatus.Status.FAILURE;
                case "upm.auditLog.config.healthcheck.warning" -> UpmConfigStatus.Status.WARNING;
                default -> UpmConfigStatus.Status.SUCCESS;
            });
        }
        return Optional.empty();
    }

    private String inlineMessages(List<Message> messages) {
        return messages.stream().map(arg_0 -> ((I18nResolver)this.i18nResolver).getText(arg_0)).collect(Collectors.joining(", "));
    }
}

