/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.servlet;

import com.atlassian.marketplace.client.model.Links;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.UpmHostApplicationInformation;
import com.atlassian.upm.UpmInformation;
import com.atlassian.upm.UpmSys;
import com.atlassian.upm.core.Sys;
import com.atlassian.upm.core.impl.UpmAppManager;
import com.atlassian.upm.core.policy.PolicyEnforcer;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.core.servlet.UpmServletHandler;
import com.atlassian.upm.license.impl.LicensedPlugins;
import com.atlassian.upm.license.internal.HostApplicationLicenseAttributes;
import com.atlassian.upm.license.internal.HostLicenseProvider;
import com.atlassian.upm.pac.PacClient;
import com.atlassian.upm.signing.api.config.UpmConfig;
import com.atlassian.upm.signing.api.config.UpmConfigStatus;
import com.atlassian.upm.velocity.UpmConfigStatusData;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class PluginManagerHandler
extends UpmServletHandler {
    public static final String SOURCE_PARAM = "source";
    public static final String SOURCE_TYPE_PARAM = "source-type";
    private final UpmInformation upm;
    private final UpmHostApplicationInformation appInfo;
    private final UpmAppManager appManager;
    private final HostLicenseProvider hostLicenseProvider;
    private final PacClient pacClient;
    private final ApplicationProperties applicationProperties;
    private final PolicyEnforcer policyEnforcer;
    private final UpmConfig upmConfig;

    public PluginManagerHandler(TemplateRenderer renderer, PermissionEnforcer permissionEnforcer, LoginUriProvider loginUriProvider, WebSudoManager webSudoManager, UpmInformation upm, UpmHostApplicationInformation appInfo, UpmAppManager appManager, HostLicenseProvider hostLicenseProvider, PacClient pacClient, ApplicationProperties applicationProperties, PolicyEnforcer policyEnforcer, UpmConfig upmConfig) {
        super(renderer, permissionEnforcer, loginUriProvider, webSudoManager);
        this.upm = Objects.requireNonNull(upm, "upm");
        this.appInfo = Objects.requireNonNull(appInfo, "appInfo");
        this.appManager = Objects.requireNonNull(appManager, "appManager");
        this.hostLicenseProvider = Objects.requireNonNull(hostLicenseProvider, "hostLicenseProvider");
        this.pacClient = Objects.requireNonNull(pacClient, "pacClient");
        this.applicationProperties = Objects.requireNonNull(applicationProperties, "applicationProperties");
        this.policyEnforcer = Objects.requireNonNull(policyEnforcer, "policyEnforcer");
        this.upmConfig = Objects.requireNonNull(upmConfig, "upmConfig");
    }

    @Override
    public Map<String, Object> getContext(HttpServletRequest request) {
        HashMap<String, Object> contextBuilder = new HashMap<String, Object>();
        contextBuilder.put("pacWebsiteUrl", UpmSys.getMpacWebsiteBaseUrl());
        contextBuilder.put("upmVersion", this.upm.getVersion());
        contextBuilder.put("macBaseurl", UpmSys.getMacBaseUrl());
        contextBuilder.put("isOnDemand", false);
        contextBuilder.put("isApplicationApiSupported", this.appManager.isApplicationSupportEnabled());
        contextBuilder.put("licensedHostUsers", this.getLicensedHostUsers());
        contextBuilder.put("isPlatformFreeTier", false);
        contextBuilder.put("hostDataCenter", this.appInfo.isHostDataCenterEnabled());
        contextBuilder.put("isCareBearServerSpecific", LicensedPlugins.isServerWithCloudAlternative(this.appInfo.getHostingType(), this.applicationProperties.getPlatformId()));
        contextBuilder.put("isPluginUploadEnabled", this.policyEnforcer.isPluginUploadEnabled());
        UpmHostApplicationInformation.AuiCapabilities ac = this.appInfo.getAuiCapabilities();
        if (ac != null) {
            contextBuilder.put("auiCapabilities", ac);
        }
        for (Links mpacLinks : this.pacClient.getMarketplaceRootLinks()) {
            for (URI uri : mpacLinks.getUri("addons")) {
                contextBuilder.put("mpacAddonsUrl", Sys.resolveMarketplaceUri(uri));
            }
        }
        contextBuilder.put("signatureCheckEnabled", this.policyEnforcer.isSignatureCheckEnabledOnUpload());
        UpmConfigStatusData upmConfigStatusData = new UpmConfigStatusData(this.upmConfig);
        contextBuilder.put("upmConfigStatus", upmConfigStatusData);
        boolean displayOptInBanner = this.upmConfig.displayOptInBanner();
        contextBuilder.put("displayCertificatesOptInMessage", displayOptInBanner);
        return Collections.unmodifiableMap(contextBuilder);
    }

    private int getLicensedHostUsers() {
        HostApplicationLicenseAttributes attrs = this.hostLicenseProvider.getHostApplicationLicenseAttributes();
        if (!attrs.isEvaluation()) {
            return attrs.getEdition().getOrElse(-1);
        }
        return 0;
    }

    private static String getConfigStatusCss(UpmConfigStatus status) {
        return switch (status.getStatus()) {
            default -> throw new MatchException(null, null);
            case UpmConfigStatus.Status.FAILURE -> "aui-message-error";
            case UpmConfigStatus.Status.SUCCESS -> "aui-message-info";
            case UpmConfigStatus.Status.WARNING -> "aui-message-warning";
        };
    }
}

