/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.signing.api;

import com.atlassian.sigillo.signature.verifier.Verifier;
import com.atlassian.sigillo.signature.verifier.VerifierFactory;
import com.atlassian.sigillo.signature.verifier.exception.VerifierException;
import com.atlassian.upm.signing.api.Certificate;
import com.atlassian.upm.signing.api.PluginChecker;
import com.atlassian.upm.signing.api.PluginInstallationOrigin;
import com.atlassian.upm.signing.api.PluginSignature;
import com.atlassian.upm.signing.api.config.UpmConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PluginCheckerImpl
implements PluginChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginCheckerImpl.class);
    private final Verifier verifier = VerifierFactory.defaultVerifier();
    private final UpmConfig config;

    public PluginCheckerImpl(UpmConfig config) {
        this.config = config;
    }

    @Override
    public boolean isSignatureCheckEnabled(PluginInstallationOrigin origin) {
        return this.config.isPluginSigningEnabled(origin);
    }

    @Override
    public boolean verify(File file, PluginSignature signature) {
        if (!this.safetyCheck()) {
            LOGGER.error("UPM Configuration healthcheck failed!");
            return false;
        }
        if (signature == null) {
            LOGGER.error("Empty signature!");
            return false;
        }
        if (signature.isEmpty()) {
            LOGGER.error("Missing signature!");
            return false;
        }
        if (file == null || !file.exists() || file.isDirectory()) {
            LOGGER.error("Invalid plugin file {}", (Object)file);
            return false;
        }
        List<String> certificates = this.config.getCertificates().stream().map(Certificate::content).toList();
        if (certificates.isEmpty()) {
            LOGGER.warn("No certificates found in Certificates store {}", (Object)this.config.getTruststorePath());
            return false;
        }
        return this.verify(file, signature, certificates);
    }

    @Override
    public boolean safetyCheck() {
        return this.config.safetyCheck();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean verify(File file, PluginSignature signature, List<String> certificates) {
        try (FileInputStream in = new FileInputStream(file);){
            if (signature.certificate() == null) {
                boolean bl = this.verifier.verifyArtifact(in, signature.signature(), certificates);
                return bl;
            }
            boolean bl = this.verifier.verifyArtifact(in, signature.signature(), signature.certificate(), certificates);
            return bl;
        }
        catch (VerifierException se) {
            LOGGER.warn("Error verifying signature ", (Throwable)se);
            return false;
        }
        catch (IOException e) {
            LOGGER.warn("Error reading file {}", (Object)file, (Object)e);
            return false;
        }
        catch (Exception e) {
            LOGGER.warn("Unexpected error during signature check {}", (Object)signature, (Object)e);
            return false;
        }
    }
}

