/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.signing.api.config;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.upm.signing.api.config.UpmConfig;
import com.atlassian.upm.signing.api.config.UpmConfigSys;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpmConfigBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpmConfigBuilder.class);
    private Path configFilePath;
    private Path trustStorePath;
    private boolean looseCheck = UpmConfigSys.isLooseCheckingAllowed();

    public boolean isLooseCheck() {
        return this.looseCheck;
    }

    public Path getConfigFilePath() {
        return this.configFilePath;
    }

    public Path getTrustStorePath() {
        return this.trustStorePath;
    }

    public static UpmConfigBuilder builder(ApplicationProperties applicationProperties) {
        UpmConfigBuilder builder = new UpmConfigBuilder();
        String legacyConfigDirectoryProperty = UpmConfigSys.getConfigurationDirectoryProperty();
        List<Path> appHomeDirectories = UpmConfigBuilder.getApplicationHomeDirectories(applicationProperties);
        if (legacyConfigDirectoryProperty != null) {
            Path configPath = UpmConfigBuilder.getConfigurationDirectory(appHomeDirectories, legacyConfigDirectoryProperty);
            builder.configFilePath = configPath.resolve("upm.properties");
            builder.trustStorePath = configPath.resolve("truststore");
        } else {
            String configFileProperty = UpmConfigSys.getConfigurationFileProperty();
            builder.configFilePath = UpmConfigBuilder.getConfigurationFile(appHomeDirectories, configFileProperty == null ? UpmConfigSys.getDefaultConfigurationFile() : configFileProperty);
            String trustStoreProperty = UpmConfigSys.getTrustStoreProperty();
            if (trustStoreProperty == null) {
                trustStoreProperty = UpmConfigBuilder.readTrustStorePropertyFromConfigurationFile(builder.configFilePath).orElse(UpmConfigSys.getDefaultTrustStore());
            }
            builder.trustStorePath = UpmConfigBuilder.getConfigurationDirectory(appHomeDirectories, trustStoreProperty);
        }
        return builder;
    }

    public UpmConfigBuilder looseCheck(boolean looseCheck) {
        this.looseCheck = looseCheck;
        return this;
    }

    public UpmConfig build() {
        return new UpmConfig(this.configFilePath, this.trustStorePath, this.looseCheck);
    }

    private static Optional<String> readTrustStorePropertyFromConfigurationFile(Path configFile) {
        if (Files.isRegularFile(configFile, new LinkOption[0])) {
            Properties properties = new Properties();
            try (FileInputStream in = new FileInputStream(configFile.toFile());){
                properties.load(in);
            }
            catch (IOException ioe) {
                LOGGER.warn("Failed to read properties from {}", (Object)configFile);
                return Optional.empty();
            }
            return Optional.ofNullable(properties.getProperty("atlassian.upm.truststore.directory"));
        }
        return Optional.empty();
    }

    private static List<Path> getApplicationHomeDirectories(ApplicationProperties applicationProperties) {
        ArrayList<Path> configDirectoryCandidates = new ArrayList<Path>();
        applicationProperties.getSharedHomeDirectory().ifPresent(configDirectoryCandidates::add);
        applicationProperties.getLocalHomeDirectory().ifPresent(configDirectoryCandidates::add);
        return configDirectoryCandidates;
    }

    private static Path getConfigurationDirectory(List<Path> appHoneDirectories, String path) {
        return UpmConfigBuilder.getConfigurationPath(appHoneDirectories, path, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
    }

    private static Path getConfigurationFile(List<Path> appHoneDirectories, String path) {
        return UpmConfigBuilder.getConfigurationPath(appHoneDirectories, path, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
    }

    private static Path getConfigurationPath(List<Path> appHomeDirectories, String path, Predicate<Path> pathFilter) {
        Path syspath = Path.of(path, new String[0]);
        if (syspath.isAbsolute()) {
            return syspath;
        }
        List<Path> candidates = Stream.concat(appHomeDirectories.stream().map(p -> p.resolve(syspath)), Stream.of(syspath)).toList();
        return candidates.stream().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).filter(pathFilter).findFirst().or(() -> UpmConfigBuilder.getFirstExistingPath(appHomeDirectories).map(p -> p.resolve(syspath))).orElse(syspath);
    }

    private static Optional<Path> getFirstExistingPath(List<Path> configDirectoryCandidates) {
        return configDirectoryCandidates.stream().filter(Objects::nonNull).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).findFirst().or(() -> configDirectoryCandidates.stream().findFirst());
    }
}

