/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.signing.api.config;

import com.atlassian.sal.api.message.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;

public record UpmConfigStatus(String description, String i18nKey, Status status, List<Message> errors, List<Message> warnings) implements Comparable<UpmConfigStatus>
{
    private UpmConfigStatus(Builder builder) {
        this(builder.description, builder.i18nKey, builder.status, builder.errors, builder.warnings);
    }

    @Override
    public int compareTo(UpmConfigStatus o) {
        return this.status.compareTo(o.status);
    }

    public UpmConfigStatus merge(UpmConfigStatus other) {
        UpmConfigStatus max = Stream.of(this, other).max(Comparator.comparing(UpmConfigStatus::getStatus)).orElse(this);
        UpmConfigStatus merge = new Builder().withStatus(max.status).withDescription(max.description).withI18nKey(max.i18nKey).build();
        merge.errors.addAll(this.errors);
        merge.errors.addAll(other.errors);
        merge.warnings.addAll(this.warnings);
        merge.warnings.addAll(other.warnings);
        return merge;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDescription() {
        return this.description;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getI18nKey() {
        return this.i18nKey;
    }

    public List<Message> getErrors() {
        return this.errors;
    }

    public List<Message> getWarnings() {
        return this.warnings;
    }

    public boolean success() {
        return this.status != Status.FAILURE;
    }

    public boolean hasMessages() {
        return !this.errors.isEmpty() || !this.warnings.isEmpty();
    }

    public static enum Status {
        SUCCESS,
        WARNING,
        FAILURE;


        public static Status get(String value) {
            return Arrays.stream(Status.values()).filter(v -> v.name().equalsIgnoreCase(value)).findFirst().orElse(SUCCESS);
        }
    }

    public static class Builder {
        private String description;
        private String i18nKey = "upm.config.check.success";
        private Status status = Status.SUCCESS;
        private final List<Message> errors = new ArrayList<Message>();
        private final List<Message> warnings = new ArrayList<Message>();

        private Builder() {
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withI18nKey(String i18nKey) {
            this.i18nKey = i18nKey;
            return this;
        }

        public Builder withStatus(Status status) {
            this.status = status;
            return this;
        }

        public Builder withError(Message message) {
            this.errors.add(message);
            return this;
        }

        public Builder withWarning(Message message) {
            this.warnings.add(message);
            return this;
        }

        public UpmConfigStatus build() {
            return new UpmConfigStatus(this);
        }
    }
}

