/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.test.rest.resources;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.pac.MpacApplicationCacheManager;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Objects;

@SystemAdminOnly
@Path(value="/refresh-cache")
public class MpacApplicationCacheRefreshResource {
    private final MpacApplicationCacheManager mpacApplicationCacheManager;
    private final PermissionEnforcer permissionEnforcer;

    @Inject
    public MpacApplicationCacheRefreshResource(MpacApplicationCacheManager mpacApplicationCacheManager, PermissionEnforcer permissionEnforcer) {
        this.mpacApplicationCacheManager = Objects.requireNonNull(mpacApplicationCacheManager);
        this.permissionEnforcer = Objects.requireNonNull(permissionEnforcer);
    }

    @PUT
    @Path(value="/populate")
    public Response updateCache(@Context HttpServletRequest request) {
        this.permissionEnforcer.enforceSystemAdmin();
        this.mpacApplicationCacheManager.populateCache();
        return Response.ok().build();
    }

    @PUT
    @Path(value="/reset")
    public Response resetCache(@Context HttpServletRequest request) {
        this.permissionEnforcer.enforceSystemAdmin();
        this.mpacApplicationCacheManager.reset();
        return Response.ok().build();
    }
}

