/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.test.rest.resources;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.core.Sys;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.core.test.rest.resources.SysResource;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

@SystemAdminOnly
@Path(value="/upm-sys")
public class UpmSysResource {
    Map<String, String> properties = new HashMap<String, String>();
    private final PermissionEnforcer permissionEnforcer;
    private static Optional<SysResource.SysUpdateValueRepresentation> dataCenterEnabled = Optional.empty();
    private static Optional<SysResource.SysUpdateValueRepresentation> mailServerStatus = Optional.empty();
    private static Optional<SenRepresentation> sen = Optional.empty();
    private static Optional<SysResource.SysUpdateValueRepresentation> autoInstall = Optional.empty();
    private static Optional<SysResource.SysUpdateValueRepresentation> purchasedAddonsFeature = Optional.empty();
    private static Optional<SysResource.SysUpdateValueRepresentation> checkLicenseFeature = Optional.empty();
    private static final Map<String, String> mktAnalyticsPaths = new HashMap<String, String>();

    @Inject
    public UpmSysResource(PermissionEnforcer permissionEnforcer) {
        this.permissionEnforcer = Objects.requireNonNull(permissionEnforcer, "permissionEnforcer");
    }

    public static Optional<String> getSen() {
        return sen.flatMap(SenRepresentation::getSen);
    }

    public static Optional<String> getMktAnalyticsPath(String type) {
        return Optional.ofNullable(mktAnalyticsPaths.get(type));
    }

    private <T> Function<Optional<T>, Option<T>> optionalToOption(Class<T> clazz) {
        return opt -> opt.map(Option::some).orElseGet(() -> Option.none());
    }

    @DELETE
    @Path(value="mkt-analytics-path/{type}")
    public Response resetMktAnalyticsPath(@PathParam(value="type") String type) {
        this.permissionEnforcer.enforceSystemAdmin();
        if (!Sys.isUpmDebugModeEnabled()) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        mktAnalyticsPaths.remove(type);
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins+json"})
    @Path(value="mkt-analytics-path/{type}")
    public Response getMktAnalyticsPathResource(@PathParam(value="type") String type) {
        this.permissionEnforcer.enforceSystemAdmin();
        if (!Sys.isUpmDebugModeEnabled()) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        String path = mktAnalyticsPaths.get(type);
        if (path == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)new SysResource.SysUpdateStringValueRepresentation(path)).build();
    }

    @PUT
    @Consumes(value={"application/vnd.atl.plugins+json"})
    @Path(value="mkt-analytics-path/{type}")
    public Response setMktAnalyticsPath(@PathParam(value="type") String type, SysResource.SysUpdateStringValueRepresentation representation) {
        this.permissionEnforcer.enforceSystemAdmin();
        if (!Sys.isUpmDebugModeEnabled()) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        mktAnalyticsPaths.put(type, representation.getValue());
        return Response.ok((Object)representation).type("application/vnd.atl.plugins+json").build();
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins+json"})
    @Path(value="sen")
    public Response getSenResource() {
        this.permissionEnforcer.enforceSystemAdmin();
        if (!Sys.isUpmDebugModeEnabled()) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        return Response.ok(this.optionalToOption(SenRepresentation.class).apply(sen)).build();
    }

    @PUT
    @Consumes(value={"application/vnd.atl.plugins+json"})
    @Path(value="sen")
    public Response setSen(SenRepresentation senRepresentation) {
        this.permissionEnforcer.enforceSystemAdmin();
        if (!Sys.isUpmDebugModeEnabled()) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        sen = Optional.of(senRepresentation);
        return Response.ok(sen).type("application/vnd.atl.plugins+json").build();
    }

    @DELETE
    @Path(value="sen")
    public Response resetSen() {
        this.permissionEnforcer.enforceSystemAdmin();
        if (!Sys.isUpmDebugModeEnabled()) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        sen = Optional.empty();
        return Response.ok().build();
    }

    private Response getBooleanResponse(Optional<SysResource.SysUpdateValueRepresentation> rep) {
        return this.checkPermission().or(() -> rep.map(value -> Response.ok((Object)value).build())).orElseGet(() -> Response.status((Response.Status)Response.Status.NOT_FOUND).build());
    }

    private Optional<Response> checkPermission() {
        this.permissionEnforcer.enforceSystemAdmin();
        if (!Sys.isUpmDebugModeEnabled()) {
            return Optional.of(Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build());
        }
        return Optional.empty();
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins+json"})
    @Path(value="data-center")
    public Response getDataCenterEnabled() {
        return this.getBooleanResponse(dataCenterEnabled);
    }

    @PUT
    @Consumes(value={"application/vnd.atl.plugins+json"})
    @Path(value="data-center")
    public Response setDataCenterEnabled(SysResource.SysUpdateValueRepresentation dataCenterEnabledRep) throws Exception {
        return this.checkPermission().orElseGet(() -> this.setValue(dataCenterEnabledRep, v -> {
            dataCenterEnabled = v;
        }));
    }

    @DELETE
    @Path(value="data-center")
    public Response resetDataCenterEnabled() {
        return this.checkPermission().orElseGet(() -> this.resetValue(v -> {
            dataCenterEnabled = v;
        }));
    }

    public static Optional<Boolean> isDataCenterEnabled() {
        return dataCenterEnabled.map(SysResource.SysUpdateValueRepresentation::getValue);
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins+json"})
    @Path(value="mail-server")
    public Response getMailServerStatus() {
        return this.getBooleanResponse(mailServerStatus);
    }

    @PUT
    @Consumes(value={"application/vnd.atl.plugins+json"})
    @Path(value="mail-server")
    public Response setMailServerStatus(SysResource.SysUpdateValueRepresentation mailServerConfiguredRepresentation) throws Exception {
        return this.checkPermission().orElseGet(() -> this.setValue(mailServerConfiguredRepresentation, v -> {
            mailServerStatus = v;
        }));
    }

    @DELETE
    @Path(value="mail-server")
    public Response resetMailServerStatus() {
        return this.checkPermission().orElseGet(() -> this.resetValue(v -> {
            mailServerStatus = v;
        }));
    }

    public static Optional<Boolean> isMailServerConfigured() {
        return mailServerStatus.map(SysResource.SysUpdateValueRepresentation::getValue);
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins+json"})
    @Path(value="auto-install-remote-plugins")
    public Response getAutoInstallRemotePlugins() {
        return this.getBooleanResponse(autoInstall);
    }

    @PUT
    @Consumes(value={"application/vnd.atl.plugins+json"})
    @Path(value="auto-install-remote-plugins")
    public Response setAutoInstallRemotePlugins(SysResource.SysUpdateValueRepresentation rep) throws Exception {
        return this.checkPermission().orElseGet(() -> this.setValue(rep, v -> {
            autoInstall = v;
        }));
    }

    @DELETE
    @Path(value="auto-install-remote-plugins")
    public Response resetAutoInstallRemotePlugins() {
        return this.resetValue(v -> {
            autoInstall = v;
        });
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins+json"})
    @Path(value="check-license")
    public Response getCheckLicenseFeature() {
        return this.getBooleanResponse(checkLicenseFeature);
    }

    @PUT
    @Consumes(value={"application/vnd.atl.plugins+json"})
    @Path(value="check-license")
    public Response setCheckLicenseFeature(SysResource.SysUpdateValueRepresentation rep) throws Exception {
        return this.checkPermission().orElseGet(() -> this.setValue(rep, v -> {
            checkLicenseFeature = v;
        }));
    }

    @DELETE
    @Path(value="check-license")
    public Response resetCheckLicenseFeature() {
        return this.checkPermission().orElseGet(() -> this.resetValue(v -> {
            checkLicenseFeature = v;
        }));
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins+json"})
    @Path(value="purchased-addons")
    public Response getPurchasedAddons() {
        return this.getBooleanResponse(purchasedAddonsFeature);
    }

    @PUT
    @Consumes(value={"application/vnd.atl.plugins+json"})
    @Path(value="purchased-addons")
    public Response setPurchasedAddons(SysResource.SysUpdateValueRepresentation rep) throws Exception {
        return this.checkPermission().orElseGet(() -> this.setValue(rep, v -> {
            purchasedAddonsFeature = v;
        }));
    }

    @DELETE
    @Path(value="purchased-addons")
    public Response resetPurchasedAddons() {
        return this.checkPermission().orElseGet(() -> this.resetValue(v -> {
            purchasedAddonsFeature = v;
        }));
    }

    private Response setValue(SysResource.SysUpdateValueRepresentation rep, Consumer<Optional<SysResource.SysUpdateValueRepresentation>> setter) {
        setter.accept(Optional.of(rep));
        return Response.ok((Object)rep).type("application/vnd.atl.plugins+json").build();
    }

    private Response resetValue(Consumer<Optional<SysResource.SysUpdateValueRepresentation>> setter) {
        setter.accept(Optional.empty());
        return Response.ok().build();
    }

    public static Optional<Boolean> isCheckLicenseFeatureEnabled() {
        return checkLicenseFeature.map(SysResource.SysUpdateValueRepresentation::getValue);
    }

    public static Optional<Boolean> isPurchasedAddonsFeatureEnabled() {
        return purchasedAddonsFeature.map(SysResource.SysUpdateValueRepresentation::getValue);
    }

    public static final class SenRepresentation {
        @JsonProperty
        private String sen;

        @JsonCreator
        public SenRepresentation(@JsonProperty(value="sen") String sen) {
            this.sen = sen;
        }

        public Optional<String> getSen() {
            return Optional.ofNullable(this.sen).filter(String::isEmpty);
        }
    }
}

