/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.transformers.template;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnderscoreTemplateCompiler {
    private static final String RE_ESCAPE = "<%-([\\s\\S]+?)%>";
    private static final String RE_EVALUATE = "<%([\\s\\S]+?)%>";
    private static final String RE_INTERPOLATE = "<%=([\\s\\S]+?)%>";
    private static final String RE_ES_TEMPLATE = "\\$\\{([^\\\\}]*+(?:\\\\.[^\\\\}]*)*)}";
    private static final String RE_EMPTY_STRING_LEADING = "\\b__p \\+= '';";
    private static final String RE_EMPTY_STRING_MIDDLE = "\\b(__p \\+=) '' \\+";
    private static final String RE_EMPTY_STRING_TRAILING = "(__e\\(.*?\\)|\\b__t\\)) \\+\\n'';";
    private static final Pattern RE_DELIMITERS = Pattern.compile("<%-([\\s\\S]+?)%>|<%=([\\s\\S]+?)%>|\\$\\{([^\\\\}]*+(?:\\\\.[^\\\\}]*)*)}|<%([\\s\\S]+?)%>|$", 32);

    public String template(String input) {
        boolean isEscaping = false;
        boolean isEvaluating = false;
        int index = 0;
        StringBuilder source = new StringBuilder("__p += '");
        Matcher matcher = RE_DELIMITERS.matcher(input);
        while (matcher.find()) {
            String escapeValue = matcher.group(1);
            String interpolateValue = matcher.group(2);
            String esTemplateValue = matcher.group(3);
            String evaluateValue = matcher.group(4);
            if (interpolateValue == null) {
                interpolateValue = esTemplateValue;
            }
            String literal = input.substring(index, matcher.start());
            source.append(UnderscoreTemplateCompiler.escapeString(literal));
            if (escapeValue != null) {
                isEscaping = true;
                source.append("' +\n__e(").append(escapeValue).append(") +\n'");
            }
            if (evaluateValue != null) {
                isEvaluating = true;
                source.append("';\n").append(evaluateValue).append(";\n__p += '");
            }
            if (interpolateValue != null) {
                source.append("' +\n((__t = (").append(interpolateValue).append(")) == null ? '' : __t) +\n'");
            }
            index = matcher.end();
        }
        source.append("';\n");
        Object body = "with (obj) {\n" + String.valueOf(source) + "\n}\n";
        if (isEvaluating) {
            body = ((String)body).replaceAll(RE_EMPTY_STRING_LEADING, "");
        }
        body = ((String)body).replaceAll(RE_EMPTY_STRING_MIDDLE, "$1");
        body = ((String)body).replaceAll(RE_EMPTY_STRING_TRAILING, "$1;");
        StringBuilder function = new StringBuilder("function(obj) {\n");
        function.append("obj || (obj = {});\n");
        function.append("var __t, __p = ''");
        if (isEscaping) {
            function.append(", __e = _.escape");
        }
        if (isEvaluating) {
            function.append(", __j = Array.prototype.join;\n");
            function.append("function print() { __p += __j.call(arguments, '') }\n");
        } else {
            function.append(";\n");
        }
        function.append((String)body);
        function.append("return __p\n}");
        return function.toString();
    }

    private static String escapeString(String str) {
        return str.replace("\\", "\\\\").replace("'", "\\'").replace("\r", "\\r").replace("\n", "\\n").replace("\u2028", "\\u2028").replace("\u2029", "\\u2029");
    }
}

