/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.velocity;

import com.atlassian.sal.api.message.Message;
import com.atlassian.upm.signing.api.config.UpmConfig;
import com.atlassian.upm.signing.api.config.UpmConfigStatus;
import java.util.List;

public class UpmConfigStatusData {
    private final UpmConfigStatus status;
    private final boolean displayConfigLocation;
    private final String configLocationLabel;
    private final String configLocation;
    private final boolean hasConfigFile;
    private final String noConfigKey;
    private final boolean displayTrustStoreLocation;
    private final String trustStoreLocationLabel;
    private final String trustStoreLocation;
    private final boolean trustStoreExists;
    private final String noTrustStoreKey;
    private final String css;
    private final boolean isPluginSigningEnabled;

    public UpmConfigStatusData(UpmConfig upmConfig) {
        UpmConfigStatus configStatus = upmConfig.configFileStatus();
        UpmConfigStatus trustStoreStatus = upmConfig.trustStoreStatus();
        this.isPluginSigningEnabled = upmConfig.isPluginSigningEnabled();
        this.status = configStatus.merge(trustStoreStatus);
        this.displayConfigLocation = UpmConfigStatusData.hasWarnings(configStatus);
        this.configLocationLabel = upmConfig.isConfigured() ? "upm.config.file.configured.location" : "upm.config.file.default.location";
        this.configLocation = upmConfig.getConfigFile().toString();
        this.hasConfigFile = upmConfig.configurationFileExists();
        this.noConfigKey = "upm.config.file.absent";
        this.css = UpmConfigStatusData.getConfigStatusCss(this.status);
        this.displayTrustStoreLocation = UpmConfigStatusData.hasWarnings(trustStoreStatus);
        this.trustStoreLocationLabel = "upm.certificates.truststore.location";
        this.trustStoreLocation = upmConfig.getTruststorePath().toString();
        this.trustStoreExists = upmConfig.hasCertificates();
        this.noTrustStoreKey = upmConfig.hasTruststore() ? "upm.truststore.empty" : "upm.truststore.absent";
    }

    private static boolean hasWarnings(UpmConfigStatus status) {
        return status.getStatus() != UpmConfigStatus.Status.SUCCESS;
    }

    public String getMessagesTitle() {
        return "upm.config.status.details";
    }

    public String getTitleKey() {
        return this.status.getI18nKey();
    }

    public boolean hasMessages() {
        return this.status.hasMessages();
    }

    public List<Message> getErrors() {
        return this.status.errors();
    }

    public List<Message> getWarnings() {
        return this.status.warnings();
    }

    public boolean success() {
        return this.status.success();
    }

    public String getCss() {
        return this.css;
    }

    public boolean isDisplayConfigLocation() {
        return this.displayConfigLocation;
    }

    public String getConfigLocationLabel() {
        return this.configLocationLabel;
    }

    public String getConfigLocation() {
        return this.configLocation;
    }

    public boolean hasConfigFile() {
        return this.hasConfigFile;
    }

    public String getNoConfigKey() {
        return this.noConfigKey;
    }

    public boolean isDisplayTrustStoreLocation() {
        return this.displayTrustStoreLocation;
    }

    public String getTrustStoreLocationLabel() {
        return this.trustStoreLocationLabel;
    }

    public String getTrustStoreLocation() {
        return this.trustStoreLocation;
    }

    public boolean hasTrustStore() {
        return this.trustStoreExists;
    }

    public String getNoTrustStoreKey() {
        return this.noTrustStoreKey;
    }

    public boolean display(String level) {
        if (this.isPluginSigningEnabled) {
            UpmConfigStatus.Status statusLevel = UpmConfigStatus.Status.get(level);
            return statusLevel.ordinal() <= this.status.getStatus().ordinal();
        }
        return false;
    }

    public boolean displayDocumentationLink() {
        return this.isPluginSigningEnabled && UpmConfigStatusData.hasWarnings(this.status);
    }

    public boolean isPluginSigningEnabled() {
        return this.isPluginSigningEnabled;
    }

    private static String getConfigStatusCss(UpmConfigStatus status) {
        return switch (status.getStatus()) {
            default -> throw new MatchException(null, null);
            case UpmConfigStatus.Status.FAILURE -> "aui-message-error";
            case UpmConfigStatus.Status.SUCCESS -> "aui-message-info";
            case UpmConfigStatus.Status.WARNING -> "aui-message-warning";
        };
    }
}

