/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.manager.events;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.secrets.manager.events.KeyDeletedEvent;
import com.atlassian.secrets.manager.events.KeyRotatedEvent;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="secretsManagerListener")
public class SecretsManagerListener {
    private static final Logger log = LoggerFactory.getLogger(SecretsManagerListener.class);
    static final String AUDIT_KEY = "secrets.manager.audit.key";
    static final String ROTATE_FAILED_SUMMARY_KEY = "secrets.manager.audit.key.rotated.failed";
    static final String ROTATE_COMPLETE_SUMMARY_KEY = "secrets.manager.audit.key.rotated.complete";
    static final String DELETE_SUMMARY_KEY = "secrets.manager.audit.key.deleted";
    static final String KEY_RESOURCE_TYPE = "affected.object.encryption.key";
    private final AuditService auditService;

    public SecretsManagerListener(AuditService auditService, EventPublisher eventPublisher) {
        this.auditService = auditService;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void onKeyRotated(KeyRotatedEvent event) {
        log.info("Key rotation {}", (Object)event.state());
        switch (event.state()) {
            case FAILED: {
                this.auditService.audit(AuditEvent.builder((AuditType)SecretsManagerListener.buildAuditType(ROTATE_FAILED_SUMMARY_KEY)).build());
                break;
            }
            case COMPLETED: {
                this.auditService.audit(AuditEvent.builder((AuditType)SecretsManagerListener.buildAuditType(ROTATE_COMPLETE_SUMMARY_KEY)).build());
            }
        }
    }

    @EventListener
    public void onKeyDeleted(KeyDeletedEvent event) {
        log.debug("Received a key deletion event");
        if (!event.result().deletedKeys().isEmpty()) {
            List<AuditResource> affectedObjects = event.result().deletedKeys().stream().map(secretKey -> SecretsManagerListener.buildResource(secretKey.path().getFileName().toString(), KEY_RESOURCE_TYPE)).toList();
            this.auditService.audit(AuditEvent.builder((AuditType)SecretsManagerListener.buildAuditType(DELETE_SUMMARY_KEY)).affectedObjects(affectedObjects).build());
        }
    }

    static AuditType buildAuditType(String summaryKey) {
        return AuditType.fromI18nKeys((CoverageArea)CoverageArea.SECURITY, (CoverageLevel)CoverageLevel.BASE, (String)AUDIT_KEY, (String)summaryKey).build();
    }

    static AuditResource buildResource(String name, String type) {
        return AuditResource.builder((String)name, (String)type).build();
    }
}

