/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.manager.rest;

import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.secrets.api.RotationState;
import com.atlassian.secrets.api.RotationStatus;
import com.atlassian.secrets.api.SecretServiceException;
import com.atlassian.secrets.manager.api.DeleteInactiveKeyResult;
import com.atlassian.secrets.manager.api.KeyManager;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/keys")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Tag(name="Security")
@SystemAdminOnly
public class KeysResource {
    private static final Logger log = LoggerFactory.getLogger(KeysResource.class);
    private final KeyManager keyManager;

    @Inject
    public KeysResource(KeyManager keyManager) {
        this.keyManager = keyManager;
    }

    @POST
    @Path(value="/rotate")
    @Operation(description="Rotate the current AES encryption key. Existing secrets will be re-encrypted with the new key.", summary="Rotate the current AES key")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returned if the key was rotated successfully"), @ApiResponse(responseCode="401", description="Returned if user is not authorized"), @ApiResponse(responseCode="406", description="Returned if the rotation cannot occur"), @ApiResponse(responseCode="500", description="Returned if an error occurs when rotating the key"), @ApiResponse(responseCode="501", description="Returned if the rotation is not supported on the instance")})
    public Response rotateKey() {
        RotationStatus rotationStatus = this.keyManager.rotateKey();
        return switch (rotationStatus.status()) {
            default -> throw new MatchException(null, null);
            case RotationState.FAILED -> KeysResource.getResponse(Response.Status.INTERNAL_SERVER_ERROR, rotationStatus);
            case RotationState.NOT_STARTED -> KeysResource.getResponse(Response.Status.NOT_ACCEPTABLE, rotationStatus);
            case RotationState.COMPLETED -> KeysResource.getResponse(Response.Status.OK, rotationStatus);
            case RotationState.NOT_IMPLEMENTED -> KeysResource.getResponse(Response.Status.NOT_IMPLEMENTED, rotationStatus);
        };
    }

    private static Response getResponse(Response.Status httpStatus, RotationStatus rotationStatus) {
        HashMap<String, String> responseMap = new HashMap<String, String>();
        responseMap.put("status", rotationStatus.status().name());
        responseMap.put("message", rotationStatus.message().orElse(null));
        ObjectMapper mapper = new ObjectMapper();
        try {
            return Response.status((Response.Status)httpStatus).entity((Object)mapper.writeValueAsString(responseMap)).build();
        }
        catch (JsonProcessingException e) {
            log.error("Failed to serialize key rotation response.", (Throwable)e);
            throw new SecretServiceException((Throwable)e);
        }
    }

    @GET
    @Path(value="/inactive")
    @Operation(description="Retrieves a list of inactive AES encryption key(s). An AES key becomes inactive after it has been rotated.", summary="Retrieve inactive AES key(s)")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returned if the keys were retrieved successfully"), @ApiResponse(responseCode="401", description="Returned if user is not authorized"), @ApiResponse(responseCode="500", description="Returned if an error occurs when retrieving the keys")})
    public Response getInactiveKeys() {
        try {
            HashMap<String, List<String>> response = new HashMap<String, List<String>>();
            List<String> inactiveKeys = this.keyManager.getInactiveKeys().stream().map(key -> key.path().getFileName().toString()).toList();
            response.put("inactiveKeys", inactiveKeys);
            return Response.ok(response).build();
        }
        catch (SecretServiceException e) {
            log.error("Error retrieving keys", (Throwable)e);
            HashMap<String, String> errorResponse = new HashMap<String, String>();
            errorResponse.put("error", e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errorResponse).build();
        }
    }

    @DELETE
    @Path(value="/inactive")
    @Operation(description="Delete the inactive AES encryption key(s). Post rotation, inactive AES key(s) can be cleaned up.", summary="Delete inactive AES key(s)")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returned if the keys were deleted successfully"), @ApiResponse(responseCode="401", description="Returned if user is not authorized"), @ApiResponse(responseCode="500", description="Returned if an error occurs when deleting the keys")})
    public Response deleteInactiveKeys() {
        DeleteInactiveKeyResult result = this.keyManager.deleteInactiveKeys();
        HashMap<String, Object> responseBody = new HashMap<String, Object>();
        List<String> deletedKeys = result.deletedKeys().stream().map(key -> key.path().getFileName().toString()).toList();
        responseBody.put("deletedKeys", deletedKeys);
        if (result.errorMessage().isEmpty()) {
            return Response.status((Response.Status)Response.Status.OK).entity(responseBody).build();
        }
        responseBody.put("error", result.errorMessage().get());
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(responseBody).build();
    }
}

