/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.manager.service;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.secrets.api.RotationState;
import com.atlassian.secrets.api.RotationStatus;
import com.atlassian.secrets.api.SecretKey;
import com.atlassian.secrets.api.SecretService;
import com.atlassian.secrets.api.SecretServiceException;
import com.atlassian.secrets.manager.api.DeleteInactiveKeyResult;
import com.atlassian.secrets.manager.api.KeyManager;
import com.atlassian.secrets.manager.events.KeyDeletedEvent;
import com.atlassian.secrets.manager.events.KeyRotatedEvent;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="keyManager")
public class DefaultAESKeyManager
implements KeyManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultAESKeyManager.class);
    private final SecretService secretService;
    private final EventPublisher eventPublisher;
    private final FileDeleter fileDeleter;

    @Autowired
    public DefaultAESKeyManager(SecretService secretService, EventPublisher eventPublisher) {
        this(secretService, eventPublisher, Files::delete);
    }

    DefaultAESKeyManager(SecretService secretService, EventPublisher eventPublisher, FileDeleter fileDeleter) {
        this.secretService = secretService;
        this.eventPublisher = eventPublisher;
        this.fileDeleter = fileDeleter;
    }

    @Override
    public RotationStatus rotateKey() {
        RotationStatus rotationStatus = this.performRotation();
        this.publishRotatedKeyEvent(rotationStatus);
        return rotationStatus;
    }

    @Override
    public Set<SecretKey> getInactiveKeys() throws SecretServiceException {
        return this.secretService.getManagement().getInactiveKeys();
    }

    @Override
    public DeleteInactiveKeyResult deleteInactiveKeys() {
        ArrayList<SecretKey> deletedKeys = new ArrayList<SecretKey>();
        Optional<String> errorMessage = Optional.empty();
        try {
            Set inactiveKeys = this.secretService.getManagement().getInactiveKeys();
            deletedKeys.ensureCapacity(inactiveKeys.size());
            for (SecretKey secretKey : inactiveKeys) {
                if (!this.deleteFileIfExists(secretKey.path())) continue;
                deletedKeys.add(secretKey);
            }
        }
        catch (Exception e) {
            log.error("Error deleting inactive encryption keys", (Throwable)e);
            errorMessage = Optional.of("Error deleting inactive encryption keys: " + e.getMessage());
        }
        DeleteInactiveKeyResult result = new DeleteInactiveKeyResult(deletedKeys, errorMessage);
        this.publishDeletedKeyEvent(result);
        return result;
    }

    private RotationStatus performRotation() {
        return this.secretService.getManagement().rotateAESKey();
    }

    private void publishRotatedKeyEvent(RotationStatus rotationStatus) {
        RotationState state = rotationStatus.status();
        if (state == RotationState.NOT_STARTED) {
            return;
        }
        KeyRotatedEvent event = new KeyRotatedEvent(state);
        this.eventPublisher.publish((Object)event);
    }

    private void publishDeletedKeyEvent(DeleteInactiveKeyResult deleteInactiveKeyResult) {
        KeyDeletedEvent event = new KeyDeletedEvent(deleteInactiveKeyResult);
        this.eventPublisher.publish((Object)event);
    }

    private boolean deleteFileIfExists(Path filePath) throws IOException {
        try {
            this.fileDeleter.deleteFile(filePath);
            return true;
        }
        catch (NoSuchFileException ignored) {
            return false;
        }
    }

    public static interface FileDeleter {
        public void deleteFile(Path var1) throws IOException;
    }
}

