/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pluginusagetopchat;

import java.util.HashMap;
import java.util.Map;

public class PluginInfo {
    private final String pluginKey;
    private final String pluginName;
    private final PluginType type;
    private final boolean isEnabled;
    private final Map<String, Integer> macroUsage;
    private int totalUsage;

    public PluginInfo(String pluginKey, String pluginName, PluginType type, boolean isEnabled) {
        this.pluginKey = pluginKey;
        this.pluginName = pluginName;
        this.type = type;
        this.isEnabled = isEnabled;
        this.macroUsage = new HashMap<String, Integer>();
        this.totalUsage = 0;
    }

    public void addMacroUsage(String macroName, int usageCount) {
        this.macroUsage.put(macroName, usageCount);
        this.recalculateTotalUsage();
    }

    private void recalculateTotalUsage() {
        this.totalUsage = this.macroUsage.values().stream().mapToInt(Integer::intValue).sum();
    }

    public boolean hasUsage() {
        return this.totalUsage > 0;
    }

    public boolean hasMacros() {
        return !this.macroUsage.isEmpty();
    }

    public String getPluginKey() {
        return this.pluginKey;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public PluginType getType() {
        return this.type;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public Map<String, Integer> getMacroUsage() {
        return new HashMap<String, Integer>(this.macroUsage);
    }

    public int getTotalUsage() {
        return this.totalUsage;
    }

    public String toString() {
        return String.format("PluginInfo{key='%s', name='%s', type=%s, enabled=%s, totalUsage=%d}", new Object[]{this.pluginKey, this.pluginName, this.type, this.isEnabled, this.totalUsage});
    }

    public static enum PluginType {
        SYSTEM_PROVIDED("System"),
        USER_INSTALLED("User"),
        UNKNOWN("Unknown");

        private final String displayName;

        private PluginType(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

