/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pluginusagetopchat;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.macro.browser.MacroMetadataManager;
import com.atlassian.confluence.macro.browser.beans.MacroMetadata;
import com.atlassian.confluence.macro.browser.beans.MacroSummary;
import com.atlassian.confluence.plugin.descriptor.XhtmlMacroModuleDescriptor;
import com.atlassian.confluence.pluginusagetopchat.FilterBy;
import com.atlassian.confluence.pluginusagetopchat.PluginInfo;
import com.atlassian.confluence.pluginusagetopchat.SortBy;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.struts.soy.ActionViewDataMappings;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

@AdminOnly
public class ViewPluginUsageAction
extends ConfluenceActionSupport {
    @ComponentImport(value="cqlSearchService")
    private CQLSearchService cqlSearchService;
    @ComponentImport
    private MacroMetadataManager macroMetadataManager;
    @ComponentImport
    private PluginMetadataManager pluginMetadataManager;
    private final Map<String, Object> data = new HashMap<String, Object>();
    private final Map<String, PluginInfo> allPluginsMap = new HashMap<String, PluginInfo>();
    private final Map<String, Map<String, Integer>> mapPluginToMapMacroCount = new HashMap<String, Map<String, Integer>>();
    private SortBy sortBy = SortBy.USAGE_DESC;
    private FilterBy filterBy = FilterBy.WITH_MACROS;

    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    @ActionViewDataMappings
    public Map<String, Object> getData() {
        return this.data;
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() {
        String requestSortBy = this.getActiveRequest().getParameter("sortBy");
        String requestFilterBy = this.getActiveRequest().getParameter("filterBy");
        if (requestSortBy != null) {
            this.sortBy = SortBy.fromValue(requestSortBy);
        }
        if (requestFilterBy != null) {
            this.filterBy = FilterBy.fromValue(requestFilterBy);
        }
        this.getAllPluginInfo();
        this.getPluginUsageInfo();
        Map<String, PluginInfo> sortedAndFilteredPlugins = this.getSortedAndFilteredPlugins(this.sortBy, this.filterBy);
        Map<String, Map<String, Object>> templateData = this.getTemplateData(sortedAndFilteredPlugins);
        this.data.put("allPlugins", templateData);
        this.data.put("currentSort", this.sortBy.getValue());
        this.data.put("currentFilter", this.filterBy.getValue());
        this.data.put("contextPath", this.getActiveRequest().getContextPath());
        return "template/pluginusageList";
    }

    public void setCQLSearchService(CQLSearchService cqlSearchService) {
        this.cqlSearchService = cqlSearchService;
    }

    public void setMacroMetadataManager(MacroMetadataManager macroMetadataManager) {
        this.macroMetadataManager = macroMetadataManager;
    }

    public void setPluginMetadataManager(PluginMetadataManager pluginMetadataManager) {
        this.pluginMetadataManager = pluginMetadataManager;
    }

    private void getAllPluginInfo() {
        Collection allPlugins = this.pluginAccessor.getPlugins();
        for (Plugin plugin : allPlugins) {
            String pluginKey = plugin.getKey();
            String pluginName = plugin.getName() != null ? plugin.getName() : pluginKey;
            PluginInfo.PluginType pluginType = this.determinePluginType(plugin);
            boolean isEnabled = this.pluginAccessor.isPluginEnabled(pluginKey);
            PluginInfo pluginInfo = new PluginInfo(pluginKey, pluginName, pluginType, isEnabled);
            this.allPluginsMap.put(pluginName, pluginInfo);
        }
    }

    private PluginInfo.PluginType determinePluginType(Plugin plugin) {
        if (plugin.isBundledPlugin() || this.pluginMetadataManager.isSystemProvided(plugin)) {
            return PluginInfo.PluginType.SYSTEM_PROVIDED;
        }
        if (this.pluginMetadataManager.isUserInstalled(plugin)) {
            return PluginInfo.PluginType.USER_INSTALLED;
        }
        return PluginInfo.PluginType.UNKNOWN;
    }

    private void updatePluginInfoWithMacroUsage(String pluginName, String macroName, Integer countOfPageUsage) {
        PluginInfo pluginInfo = this.allPluginsMap.get(pluginName);
        if (pluginInfo != null) {
            pluginInfo.addMacroUsage(macroName, countOfPageUsage);
        }
    }

    private Map<String, PluginInfo> getSortedAndFilteredPlugins(SortBy sortBy, FilterBy filterBy) {
        Stream<Map.Entry<String, PluginInfo>> stream = this.allPluginsMap.entrySet().stream();
        stream = this.applyFilter(stream, filterBy);
        Comparator<Map.Entry<String, PluginInfo>> comparator = this.getComparator(sortBy);
        return stream.sorted(comparator).collect(LinkedHashMap::new, (map, entry) -> map.put((String)entry.getKey(), (PluginInfo)entry.getValue()), HashMap::putAll);
    }

    private Map<String, Map<String, Object>> getTemplateData(Map<String, PluginInfo> pluginInfoMap) {
        LinkedHashMap<String, Map<String, Object>> templateData = new LinkedHashMap<String, Map<String, Object>>();
        for (Map.Entry<String, PluginInfo> entry : pluginInfoMap.entrySet()) {
            PluginInfo pluginInfo = entry.getValue();
            HashMap<String, Object> pluginData = new HashMap<String, Object>();
            pluginData.put("pluginKey", pluginInfo.getPluginKey());
            pluginData.put("pluginName", pluginInfo.getPluginName());
            pluginData.put("type", pluginInfo.getType().name());
            pluginData.put("enabled", pluginInfo.isEnabled());
            pluginData.put("totalUsage", pluginInfo.getTotalUsage());
            pluginData.put("hasMacros", pluginInfo.hasMacros());
            pluginData.put("macroUsage", pluginInfo.getMacroUsage());
            templateData.put(entry.getKey(), pluginData);
        }
        return templateData;
    }

    private Stream<Map.Entry<String, PluginInfo>> applyFilter(Stream<Map.Entry<String, PluginInfo>> stream, FilterBy filterBy) {
        return switch (filterBy) {
            case FilterBy.SYSTEM_PROVIDED -> stream.filter(e -> ((PluginInfo)e.getValue()).getType() == PluginInfo.PluginType.SYSTEM_PROVIDED);
            case FilterBy.USER_INSTALLED -> stream.filter(e -> ((PluginInfo)e.getValue()).getType() == PluginInfo.PluginType.USER_INSTALLED);
            case FilterBy.USED -> stream.filter(e -> ((PluginInfo)e.getValue()).hasUsage());
            case FilterBy.UNUSED -> stream.filter(e -> !((PluginInfo)e.getValue()).hasUsage());
            case FilterBy.WITH_MACROS -> stream.filter(e -> ((PluginInfo)e.getValue()).hasMacros());
            case FilterBy.WITHOUT_MACROS -> stream.filter(e -> !((PluginInfo)e.getValue()).hasMacros());
            default -> stream;
        };
    }

    private Comparator<Map.Entry<String, PluginInfo>> getComparator(SortBy sortBy) {
        if (sortBy == SortBy.USAGE_ASC) {
            return Map.Entry.comparingByValue(Comparator.comparingInt(PluginInfo::getTotalUsage));
        }
        return Map.Entry.comparingByValue(Comparator.comparingInt(PluginInfo::getTotalUsage).reversed());
    }

    private void getPluginUsageInfo() {
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(XhtmlMacroModuleDescriptor.class);
        for (MacroMetadata macroData : this.macroMetadataManager.getAllMacroMetadata()) {
            MacroSummary macroSummary = macroData.extractMacroSummary();
            String pluginKey = this.resolveOriginalPluginKey(descriptors, macroSummary);
            Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
            String pluginName = plugin == null ? pluginKey : plugin.getName();
            String macroName = macroData.getMacroName();
            String cqlQuery = "macro = '" + macroName + "'";
            Integer countOfPageUsage = this.cqlSearchService.countContent(cqlQuery);
            this.appendPluginUsageData(pluginName, macroName, countOfPageUsage);
            this.updatePluginInfoWithMacroUsage(pluginName, macroName, countOfPageUsage);
        }
    }

    private String resolveOriginalPluginKey(List<XhtmlMacroModuleDescriptor> descriptors, MacroSummary macroSummary) {
        if (macroSummary.getMacroName().equals("gadget")) {
            return "com.atlassian.confluence.plugins.gadgets";
        }
        Optional<XhtmlMacroModuleDescriptor> descriptor = descriptors.stream().filter(d -> d.getName().equals(macroSummary.getMacroName())).findFirst();
        if (descriptor.isPresent() && descriptor.get().getPluginKey().equals("com.atlassian.plugins.atlassian-connect-plugin")) {
            String key = descriptor.get().getKey();
            int indexOfKeyDelimiter = key.indexOf("__");
            if (indexOfKeyDelimiter > 0) {
                return key.substring(0, indexOfKeyDelimiter);
            }
            return macroSummary.getPluginKey();
        }
        return macroSummary.getPluginKey();
    }

    private void appendPluginUsageData(String pluginName, String macroName, Integer countOfPageUsage) {
        if (this.mapPluginToMapMacroCount.containsKey(pluginName)) {
            Map<String, Integer> mapMacroCount = this.mapPluginToMapMacroCount.get(pluginName);
            mapMacroCount.put(macroName, countOfPageUsage);
        } else {
            HashMap<String, Integer> mapMacroCount = new HashMap<String, Integer>();
            mapMacroCount.put(macroName, countOfPageUsage);
            this.mapPluginToMapMacroCount.put(pluginName, mapMacroCount);
        }
    }

    public void setSortBy(String sortBy) {
        this.sortBy = SortBy.fromValue(sortBy);
    }

    public void setFilterBy(String filterBy) {
        this.filterBy = FilterBy.fromValue(filterBy);
    }
}

