/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.crypto;

import com.atlassian.crowd.crypto.DirectoryPasswordsEncryptor;
import com.atlassian.crowd.crypto.NoopSecretServiceInternal;
import com.atlassian.crowd.embedded.api.DataReEncryptor;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.directory.ImmutableDirectory;
import com.atlassian.crowd.search.query.DirectoryQueries;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.secret.SecretNamespace;
import com.atlassian.crowd.secret.SecretServiceInternal;
import com.atlassian.secrets.api.SecretServiceDisabledException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptingDirectoryDAO
implements DirectoryDao,
DataReEncryptor {
    private static final Logger log = LoggerFactory.getLogger(EncryptingDirectoryDAO.class);
    private DirectoryDao delegate;
    private DirectoryPasswordsEncryptor legacyEncryptor;
    private SecretServiceInternal secretServiceInternal = new NoopSecretServiceInternal();

    public void setDelegate(DirectoryDao delegate) {
        this.delegate = delegate;
    }

    public void setDirectoryPasswordsEncryptor(DirectoryPasswordsEncryptor directoryPasswordsEncryptor) {
        this.legacyEncryptor = directoryPasswordsEncryptor;
    }

    public void setSecretServiceInternal(SecretServiceInternal secretServiceInternal) {
        this.secretServiceInternal = secretServiceInternal;
    }

    public Directory findById(long directoryId) throws DirectoryNotFoundException {
        Directory directory = this.delegate.findById(directoryId);
        try {
            return this.withSecretsFromSecretService(directory);
        }
        catch (SecretServiceDisabledException e) {
            log.debug("Secret service disabled, using legacy decryption to find directory with ID: {}", (Object)directoryId);
            this.warnIfUsesSecretService(directory);
            return this.legacyEncryptor.decryptPasswords(directory);
        }
    }

    public Directory findByName(String name) throws DirectoryNotFoundException {
        Directory directory = this.delegate.findByName(name);
        try {
            return this.withSecretsFromSecretService(directory);
        }
        catch (SecretServiceDisabledException e) {
            log.debug("Secret service disabled, using legacy decryption to find directory with name: {}", (Object)name);
            this.warnIfUsesSecretService(directory);
            return this.legacyEncryptor.decryptPasswords(directory);
        }
    }

    public List<Directory> findAll() {
        try {
            return this.delegate.findAll().stream().map(this::withSecretsFromSecretService).collect(Collectors.toList());
        }
        catch (SecretServiceDisabledException e) {
            return this.doLegacyFindAll();
        }
    }

    public Directory add(Directory directory) {
        Directory added = this.delegate.add(this.withSanitizedSecrets(directory));
        try {
            Map<String, String> unsealedSecretAttributes = this.getSecretAttributes(directory);
            this.saveAttributesInSecretService(added.getId(), unsealedSecretAttributes);
            ImmutableDirectory.Builder decrypted = ImmutableDirectory.builder((Directory)added);
            unsealedSecretAttributes.forEach((arg_0, arg_1) -> ((ImmutableDirectory.Builder)decrypted).setAttribute(arg_0, arg_1));
            return decrypted.build();
        }
        catch (SecretServiceDisabledException e) {
            return this.doLegacyAdd(directory, added);
        }
    }

    public Directory update(Directory directory) throws DirectoryNotFoundException {
        try {
            Directory updated = this.delegate.update(this.withSanitizedSecrets(directory));
            DirectoryImpl.PASSWORD_ATTRIBUTES.forEach(secretAttributeKey -> this.secretServiceInternal.delete(SecretNamespace.INTERNAL, this.buildSecretIdentifier(directory.getId(), (String)secretAttributeKey)));
            Map<String, String> unsealedSecretAttributes = this.getSecretAttributes(directory);
            this.saveAttributesInSecretService(updated.getId(), unsealedSecretAttributes);
            ImmutableDirectory.Builder decrypted = ImmutableDirectory.builder((Directory)updated);
            unsealedSecretAttributes.forEach((arg_0, arg_1) -> ((ImmutableDirectory.Builder)decrypted).setAttribute(arg_0, arg_1));
            return decrypted.build();
        }
        catch (SecretServiceDisabledException e) {
            return this.doLegacyUpdate(directory);
        }
    }

    public void remove(Directory directory) throws DirectoryNotFoundException {
        try {
            this.delegate.remove(directory);
            this.getSecretAttributes(directory).keySet().forEach(secretAttributeKey -> this.secretServiceInternal.delete(SecretNamespace.INTERNAL, this.buildSecretIdentifier(directory.getId(), (String)secretAttributeKey)));
        }
        catch (SecretServiceDisabledException e) {
            log.warn("Secret service is disabled. Cannot remove secrets stored in secret service for directory {}.", (Object)directory.getId());
        }
    }

    public List<Directory> search(EntityQuery<Directory> entityQuery) {
        try {
            return this.delegate.search(entityQuery).stream().map(this::withSecretsFromSecretService).collect(Collectors.toList());
        }
        catch (SecretServiceDisabledException e) {
            return this.doLegacySearch(entityQuery);
        }
    }

    public void reEncrypt() {
        this.delegate.search(DirectoryQueries.allDirectories()).forEach(directory -> {
            try {
                log.info("Re-encryption of Directory[{}]", (Object)directory.getId());
                Directory decrypted = this.usesSecretService((Directory)directory) ? this.withSecretsFromSecretService((Directory)directory) : this.legacyEncryptor.decryptPasswords((Directory)directory);
                this.saveAttributesInSecretService(decrypted.getId(), this.getSecretAttributes(decrypted));
                this.delegate.update(this.withSanitizedSecrets((Directory)directory));
            }
            catch (SecretServiceDisabledException e) {
                this.doLegacyReEncrypt((Directory)directory);
            }
            catch (Exception e) {
                log.error("Failed to perform re-encryption on directory {}.", (Object)directory.getId(), (Object)e);
            }
        });
    }

    private List<Directory> doLegacyFindAll() {
        log.debug("Secret service disabled, using legacy decryption to find all directories");
        return this.delegate.findAll().stream().map(directory -> {
            this.warnIfUsesSecretService((Directory)directory);
            return this.legacyEncryptor.decryptPasswords((Directory)directory);
        }).collect(Collectors.toList());
    }

    private Directory doLegacyAdd(Directory directory, Directory added) {
        log.debug("Secret service disabled, using legacy encryption to add directory {}", (Object)directory.getName());
        Directory encryptedDirectory = this.legacyEncryptor.encryptPasswords(directory);
        ImmutableDirectory encryptedDirectoryWithId = ImmutableDirectory.builder((Directory)encryptedDirectory).setId(added.getId()).build();
        try {
            added = this.delegate.update((Directory)encryptedDirectoryWithId);
        }
        catch (DirectoryNotFoundException e1) {
            added = this.delegate.add(encryptedDirectory);
        }
        return this.legacyEncryptor.decryptPasswords(added);
    }

    private Directory doLegacyUpdate(Directory directory) throws DirectoryNotFoundException {
        log.debug("Secret service disabled, using legacy encryption to update directory {}", (Object)directory.getName());
        Directory encryptedDirectory = this.legacyEncryptor.encryptPasswords(directory);
        Directory updated = this.delegate.update(encryptedDirectory);
        return this.legacyEncryptor.decryptPasswords(updated);
    }

    private List<Directory> doLegacySearch(EntityQuery<Directory> entityQuery) {
        log.debug("Secret service disabled, using legacy decryption to search directories");
        return this.delegate.search(entityQuery).stream().map(directory -> {
            this.warnIfUsesSecretService((Directory)directory);
            return this.legacyEncryptor.decryptPasswords((Directory)directory);
        }).collect(Collectors.toList());
    }

    private void doLegacyReEncrypt(Directory directory) {
        log.debug("Secret service disabled, re-encrypting directory {} using legacy encryptor", (Object)directory.getId());
        try {
            if (this.usesSecretService(directory)) {
                log.error("Could not re-encrypt directory {} because Secret Service is disabled", (Object)directory.getId());
            } else {
                Directory decrypted = this.legacyEncryptor.decryptPasswords(directory);
                this.delegate.update(this.legacyEncryptor.encryptPasswords(decrypted));
            }
        }
        catch (Exception e2) {
            log.error("Failed to perform legacy re-encryption on directory {}.", (Object)directory.getId(), (Object)e2);
        }
    }

    private void saveAttributesInSecretService(Long directoryId, Map<String, String> secretAttributes) {
        secretAttributes.entrySet().stream().filter(attribute -> attribute.getValue() != null).forEach(attribute -> this.secretServiceInternal.put(SecretNamespace.INTERNAL, this.buildSecretIdentifier(directoryId, (String)attribute.getKey()), (String)attribute.getValue()));
    }

    private Directory withSecretsFromSecretService(Directory directory) {
        HashMap<String, String> decryptedAttributes = new HashMap<String, String>();
        for (Map.Entry attribute : directory.getAttributes().entrySet()) {
            if (DirectoryImpl.PASSWORD_ATTRIBUTES.contains(attribute.getKey())) {
                Optional maybeUnsealedSecretService = this.secretServiceInternal.get(SecretNamespace.INTERNAL, this.buildSecretIdentifier(directory.getId(), (String)attribute.getKey()));
                if (maybeUnsealedSecretService.isPresent()) {
                    decryptedAttributes.put((String)attribute.getKey(), (String)maybeUnsealedSecretService.get());
                    continue;
                }
                if ("{ATL_SECURED}".equals(attribute.getValue())) {
                    throw new IllegalStateException("Directory " + directory.getName() + " secrets cannot be decrypted, because Secret Service is disabled.");
                }
                decryptedAttributes.put((String)attribute.getKey(), (String)attribute.getValue());
                continue;
            }
            decryptedAttributes.put((String)attribute.getKey(), (String)attribute.getValue());
        }
        return ImmutableDirectory.builder((Directory)directory).setAttributes(decryptedAttributes).build();
    }

    private Directory withSanitizedSecrets(Directory directory) {
        ImmutableDirectory.Builder sanitizedBuilder = ImmutableDirectory.builder((Directory)directory);
        DirectoryImpl.PASSWORD_ATTRIBUTES.stream().filter(secretAttribute -> directory.getAttributes().get(secretAttribute) != null).forEach(secretAttributeKey -> sanitizedBuilder.setAttribute(secretAttributeKey, "{ATL_SECURED}"));
        return sanitizedBuilder.build();
    }

    private Map<String, String> getSecretAttributes(Directory directory) {
        HashMap<String, String> secretAttributes = new HashMap<String, String>();
        DirectoryImpl.PASSWORD_ATTRIBUTES.stream().filter(directory.getAttributes()::containsKey).forEach(secretAttributeKey -> secretAttributes.put((String)secretAttributeKey, (String)directory.getAttributes().get(secretAttributeKey)));
        return secretAttributes;
    }

    private boolean usesSecretService(Directory directory) {
        return DirectoryImpl.PASSWORD_ATTRIBUTES.stream().anyMatch(secretAttributeKey -> "{ATL_SECURED}".equals(directory.getAttributes().get(secretAttributeKey)));
    }

    private void warnIfUsesSecretService(Directory directory) {
        if (this.usesSecretService(directory)) {
            log.warn("Secret service is disabled. Cannot decrypt passwords of directory {}", (Object)directory.getName());
        }
    }

    private String buildSecretIdentifier(Long directoryId, String attributeKey) {
        return directoryId + "-" + attributeKey;
    }
}

