/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.crypto;

import com.atlassian.crowd.crypto.PropertyEncryptor;
import com.atlassian.crowd.dao.property.PropertyDAO;
import com.atlassian.crowd.embedded.api.DataReEncryptor;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.property.Property;
import com.atlassian.crowd.secret.SecretNamespace;
import com.atlassian.crowd.secret.SecretServiceInternal;
import com.atlassian.secrets.api.SecretServiceDisabledException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptingPropertyDAO
implements PropertyDAO,
DataReEncryptor {
    private final Logger log = LoggerFactory.getLogger(EncryptingPropertyDAO.class);
    private PropertyDAO delegate;
    private SecretServiceInternal secretServiceInternal;
    private PropertyEncryptor legacyEncryptor;

    public void setDelegate(PropertyDAO delegate) {
        this.delegate = delegate;
    }

    public void setSecretServiceInternal(SecretServiceInternal secretServiceInternal) {
        this.secretServiceInternal = secretServiceInternal;
    }

    public void setEncryptor(PropertyEncryptor encryptor) {
        this.legacyEncryptor = encryptor;
    }

    @Override
    public Property find(String key, String name) throws ObjectNotFoundException {
        return this.isSecret(key, name) ? this.getSecretProperty(key, name) : this.delegate.find(key, name);
    }

    @Override
    public List<Property> findAll() {
        ArrayList<Property> properties = new ArrayList<Property>();
        Map<String, Set<String>> secretPropertyNames = this.legacyEncryptor.getSecretPropertyNames();
        secretPropertyNames.forEach((key, names) -> names.forEach(name -> {
            try {
                properties.add(this.getSecretProperty((String)key, (String)name));
            }
            catch (ObjectNotFoundException ignored) {
                this.log.debug("Secret property {}.{} not found", key, name);
            }
        }));
        this.delegate.findAll().stream().filter(property -> !this.isSecret(property.getKey(), property.getName())).forEach(properties::add);
        return properties;
    }

    @Override
    public List<Property> findAll(String key) {
        ArrayList<Property> properties = new ArrayList<Property>();
        Map<String, Set<String>> secretPropertyNames = this.legacyEncryptor.getSecretPropertyNames();
        secretPropertyNames.getOrDefault(key, Set.of()).forEach(name -> {
            try {
                properties.add(this.getSecretProperty(key, (String)name));
            }
            catch (ObjectNotFoundException ignored) {
                this.log.debug("Secret property {} not found under key {}", name, (Object)key);
            }
        });
        this.delegate.findAll().stream().filter(property -> !this.isSecret(property.getKey(), property.getName())).forEach(properties::add);
        return properties;
    }

    @Override
    public Property add(Property property) {
        if (!this.isSecret(property.getKey(), property.getName())) {
            return this.delegate.add(property);
        }
        try {
            String secretIdentifier = this.buildSecretIdentifier(property.getKey(), property.getName());
            this.secretServiceInternal.get(SecretNamespace.INTERNAL, secretIdentifier).ifPresentOrElse(oldSecret -> {
                throw new IllegalArgumentException(String.format("Secret %s.%s already exists.", property.getKey(), property.getName()));
            }, () -> {
                if (property.getValue() != null) {
                    this.secretServiceInternal.put(SecretNamespace.INTERNAL, secretIdentifier, property.getValue());
                }
            });
            return property;
        }
        catch (SecretServiceDisabledException e) {
            this.log.debug("Secret Service is disabled, using legacy encryptor to add property {}.{}", (Object)property.getKey(), (Object)property.getName());
            return this.legacyEncryptor.decrypt(this.delegate.add(this.legacyEncryptor.encrypt(property)));
        }
    }

    @Override
    public Property update(Property property) {
        if (!this.isSecret(property.getKey(), property.getName())) {
            return this.delegate.update(property);
        }
        try {
            String secretIdentifier = this.buildSecretIdentifier(property.getKey(), property.getName());
            if (property.getValue() == null) {
                this.secretServiceInternal.delete(SecretNamespace.INTERNAL, secretIdentifier);
                return property;
            }
            this.secretServiceInternal.put(SecretNamespace.INTERNAL, secretIdentifier, property.getValue());
            return property;
        }
        catch (SecretServiceDisabledException e) {
            this.log.debug("Secret Service is disabled, using legacy encryptor to update property {}.{}", (Object)property.getKey(), (Object)property.getName());
            return this.legacyEncryptor.decrypt(this.delegate.update(this.legacyEncryptor.encrypt(property)));
        }
    }

    @Override
    public void remove(String key, String name) {
        if (this.isSecret(key, name)) {
            try {
                this.secretServiceInternal.delete(SecretNamespace.INTERNAL, this.buildSecretIdentifier(key, name));
            }
            catch (SecretServiceDisabledException e) {
                this.log.debug("Secret Service is disabled, using legacy decryptor to remove property {}.{}", (Object)key, (Object)name);
                this.delegate.remove(key, name);
            }
        } else {
            this.delegate.remove(key, name);
        }
    }

    public void reEncrypt() {
        Map<String, Set<String>> secretPropertyNames = this.legacyEncryptor.getSecretPropertyNames();
        secretPropertyNames.forEach((key, names) -> names.forEach(name -> {
            try {
                String unsealedValue;
                this.log.info("Re-encryption of property []", name);
                String secretIdentifier = this.buildSecretIdentifier((String)key, (String)name);
                Optional maybeUnsealedValue = this.secretServiceInternal.get(SecretNamespace.INTERNAL, secretIdentifier);
                String string = unsealedValue = maybeUnsealedValue.isPresent() ? (String)maybeUnsealedValue.get() : this.legacyEncryptor.decrypt(this.delegate.find((String)key, (String)name)).getValue();
                if (unsealedValue != null) {
                    this.secretServiceInternal.put(SecretNamespace.INTERNAL, secretIdentifier, unsealedValue);
                }
                this.delegate.remove((String)key, (String)name);
            }
            catch (SecretServiceDisabledException e) {
                this.log.debug("Secret service disabled, using legacy encryptor to re-encrypt all properties.");
                try {
                    Property decrypted = this.legacyEncryptor.decrypt(this.delegate.find((String)key, (String)name));
                    this.delegate.update(this.legacyEncryptor.encrypt(decrypted));
                }
                catch (ObjectNotFoundException ignored) {
                    this.log.debug("Secret property {}.{} not found during legacy re-encryption", key, name);
                }
            }
            catch (ObjectNotFoundException ignored) {
                this.log.debug("Secret property {}.{} not found during re-encryption", key, name);
            }
        }));
    }

    private Property getSecretProperty(String key, String name) throws ObjectNotFoundException {
        try {
            return this.secretServiceInternal.get(SecretNamespace.INTERNAL, this.buildSecretIdentifier(key, name)).map(unsealedSecret -> new Property(key, name, (String)unsealedSecret)).orElseThrow(() -> new ObjectNotFoundException(String.format("Secret property %s.%s not found.", key, name)));
        }
        catch (SecretServiceDisabledException e) {
            this.log.debug("Secret Service is disabled, using legacy decryptor to fetch property {}.{}.", (Object)key, (Object)name);
            return this.legacyEncryptor.decrypt(this.delegate.find(key, name));
        }
    }

    private boolean isSecret(String key, String name) {
        return this.legacyEncryptor.getSecretPropertyNames().getOrDefault(key, Set.of()).contains(name);
    }

    private String buildSecretIdentifier(String key, String name) {
        return key + "." + name;
    }
}

