/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.crypto;

import com.atlassian.crowd.embedded.api.Encryptor;
import com.atlassian.crowd.model.property.Property;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.apache.commons.lang3.StringUtils;

public class PropertyEncryptor {
    private Encryptor encryptor;
    private Map<String, Set<String>> secretPropertyNames;

    public PropertyEncryptor(Encryptor encryptor) {
        this(encryptor, Map.of("crowd", Set.of("mailserver.password")));
    }

    public PropertyEncryptor(Encryptor encryptor, Map<String, Set<String>> secretPropertyNames) {
        this.encryptor = encryptor;
        this.secretPropertyNames = secretPropertyNames;
    }

    public Map<String, Set<String>> getSecretPropertyNames() {
        return this.secretPropertyNames;
    }

    public Property encrypt(Property property) {
        return this.transform(property, arg_0 -> ((Encryptor)this.encryptor).encrypt(arg_0));
    }

    public Property decrypt(Property property) {
        return this.transform(property, arg_0 -> ((Encryptor)this.encryptor).decrypt(arg_0));
    }

    public Property transform(Property property, UnaryOperator<String> transformer) {
        return this.shouldEncrypt(property) ? new Property(property.getKey(), property.getName(), (String)transformer.apply(property.getValue())) : property;
    }

    private boolean shouldEncrypt(Property property) {
        return StringUtils.isNotEmpty((CharSequence)property.getValue()) && this.secretPropertyNames.getOrDefault(property.getKey(), Collections.emptySet()).contains(property.getName());
    }
}

