/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.InternalDirectoryUtils;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.PasswordConstraint;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.PasswordPolicyConfiguration;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.ValidatePasswordRequest;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.OperationNotSupportedException;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.util.I18nHelper;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalDirectoryUtilsImpl
implements InternalDirectoryUtils {
    private static final Logger log = LoggerFactory.getLogger(InternalDirectoryUtilsImpl.class);
    private final I18nHelper i18nHelper;
    private final CrowdDirectoryService crowdDirectoryService;

    public InternalDirectoryUtilsImpl(I18nHelper i18nHelper, CrowdDirectoryService crowdDirectoryService) {
        this.i18nHelper = i18nHelper;
        this.crowdDirectoryService = crowdDirectoryService;
    }

    @Override
    public void validateDirectoryForEntity(DirectoryEntity entity, Long directoryId) {
        Validate.notNull((Object)entity, (String)"entity cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getDirectoryId(), (String)"directoryId of entity cannot be null", (Object[])new Object[0]);
        Validate.isTrue((entity.getDirectoryId() == directoryId.longValue() ? 1 : 0) != 0, (String)"directoryId does not match the directoryId of the InternalDirectory", (Object[])new Object[0]);
    }

    @Override
    public void validateUsername(String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalArgumentException("A username must not be null or empty or blank");
        }
    }

    @Override
    public void validateCredential(User user, PasswordCredential credential, Set<PasswordConstraint> passwordConstraints, @Nullable String passwordComplexityMessage) throws InvalidCredentialException {
        if (user == null) {
            throw new NullPointerException("user cannot be null");
        }
        if (credential == null) {
            throw new NullPointerException("credential cannot be null");
        }
        if (!credential.isEncryptedCredential()) {
            if (StringUtils.isBlank((CharSequence)credential.getCredential())) {
                throw new InvalidCredentialException("You cannot have an empty password");
            }
            Collection failedConstraints = passwordConstraints.stream().filter(InternalDirectoryUtilsImpl.validationFailed(user, credential)).collect(Collectors.toSet());
            if (!failedConstraints.isEmpty()) {
                String message = Objects.requireNonNullElse(passwordComplexityMessage, this.i18nHelper.getText("passwordupdate.policy.complexity.error.message"));
                try {
                    PasswordPolicyConfiguration passwordPolicyConfiguration = this.crowdDirectoryService.getPasswordPolicyConfiguration(user.getDirectoryId());
                    throw new InvalidCredentialException(StringUtils.stripToNull((String)message), passwordPolicyConfiguration, failedConstraints);
                }
                catch (DirectoryNotFoundException | OperationNotSupportedException e) {
                    log.warn("Failed to get password policy configuration", e);
                    throw new InvalidCredentialException(StringUtils.stripToNull((String)message), failedConstraints);
                }
            }
        }
    }

    @Override
    public void validateGroupName(Group group, String groupName) {
        if (StringUtils.isBlank((CharSequence)groupName)) {
            throw new IllegalArgumentException("A group name must not be null or empty or blank");
        }
    }

    private static Predicate<PasswordConstraint> validationFailed(User user, PasswordCredential password) {
        return constraint -> !constraint.validate(new ValidatePasswordRequest(password, user));
    }
}

