/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.sso;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.crowd.model.sso.idp.SAMLTrustEntity;
import com.atlassian.crowd.secret.SecretNamespace;
import com.atlassian.crowd.secret.SecretServiceInternal;
import com.atlassian.secrets.api.SecretService;
import com.atlassian.secrets.api.SecretServiceState;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAMLTrustEntityDaoSecretsWrapper {
    private static final Logger log = LoggerFactory.getLogger(SAMLTrustEntityDaoSecretsWrapper.class);
    private SecretServiceInternal secretServiceInternal;

    public SAMLTrustEntityDaoSecretsWrapper(SecretServiceInternal secretService) {
        this.secretServiceInternal = secretService;
    }

    public boolean isEnabled() {
        return SecretService.getState() == SecretServiceState.ENABLED;
    }

    public SAMLTrustEntity saveSecurely(SAMLTrustEntity samlTrustEntity, Consumer<SAMLTrustEntity> saveFunction) {
        PemSecrets secrets = SAMLTrustEntityDaoSecretsWrapper.getSamlTrustSecrets(samlTrustEntity);
        SAMLTrustEntityDaoSecretsWrapper.sanitizeEntity(samlTrustEntity);
        saveFunction.accept(samlTrustEntity);
        this.storeSecrets(samlTrustEntity.getId(), secrets);
        return this.newEntityWithSecrets(samlTrustEntity, secrets);
    }

    public Optional<SAMLTrustEntity> findById(long trustEntityId, Function<Long, Optional<SAMLTrustEntity>> findFunction) {
        return findFunction.apply(trustEntityId).map(this::enrichWithSecrets);
    }

    public List<SAMLTrustEntity> findAll(Supplier<List<SAMLTrustEntity>> findAllFunction) {
        return findAllFunction.get().stream().map(this::enrichWithSecrets).toList();
    }

    public void reEncrypt(Supplier<List<SAMLTrustEntity>> findAllFunction, Consumer<SAMLTrustEntity> updateFunction) {
        findAllFunction.get().forEach(entity -> {
            PemSecrets secrets = SAMLTrustEntityDaoSecretsWrapper.getSamlTrustSecrets(entity);
            this.storeSecrets(entity.getId(), secrets);
            SAMLTrustEntityDaoSecretsWrapper.sanitizeEntity(entity);
            updateFunction.accept((SAMLTrustEntity)entity);
        });
    }

    private SAMLTrustEntity enrichWithSecrets(SAMLTrustEntity entity) {
        return this.retrieveSecrets(entity.getId()).map(secrets -> this.newEntityWithSecrets(entity, (PemSecrets)secrets)).orElse(entity);
    }

    private SAMLTrustEntity newEntityWithSecrets(SAMLTrustEntity samlTrustEntity, PemSecrets secrets) {
        return new SAMLTrustEntity.Builder(samlTrustEntity, secrets.certificate, secrets.privateKey).build();
    }

    private static void sanitizeEntity(SAMLTrustEntity samlTrustEntity) {
        Optional.ofNullable(samlTrustEntity.getPemCertificate()).ifPresentOrElse(pemCertificate -> samlTrustEntity.getPemCertificate().setPemCertificate("{ATL_SECURED}"), () -> log.error("PemCertificate is null for SAMLTrustEntity with id: {}", (Object)samlTrustEntity.getId()));
        Optional.ofNullable(samlTrustEntity.getPemPrivateKey()).ifPresentOrElse(pemPrivateKey -> samlTrustEntity.getPemPrivateKey().setPemKey("{ATL_SECURED}"), () -> log.error("PemPrivateKey is null for SAMLTrustEntity with id: {}", (Object)samlTrustEntity.getId()));
    }

    private void storeSecrets(Long id, PemSecrets secrets) {
        String certId = PemSecrets.certIdentifier(id);
        this.secretServiceInternal.put(SecretNamespace.INTERNAL, certId, secrets.certificate);
        String keyId = PemSecrets.keyIdentifier(id);
        this.secretServiceInternal.put(SecretNamespace.INTERNAL, keyId, secrets.privateKey);
    }

    private Optional<PemSecrets> retrieveSecrets(Long entityId) {
        String certificate = this.secretServiceInternal.get(SecretNamespace.INTERNAL, PemSecrets.certIdentifier(entityId)).orElse(null);
        String privateKey = this.secretServiceInternal.get(SecretNamespace.INTERNAL, PemSecrets.keyIdentifier(entityId)).orElse(null);
        if (certificate == null || privateKey == null) {
            log.error("Secrets not found for SAMLTrustEntity with id: {}", (Object)entityId);
            return Optional.empty();
        }
        return Optional.of(new PemSecrets(certificate, privateKey));
    }

    private static PemSecrets getSamlTrustSecrets(SAMLTrustEntity samlTrustEntity) {
        String certificateText = samlTrustEntity.getPemCertificate().getPemCertificate();
        String privateKeyText = samlTrustEntity.getPemPrivateKey().getPemKey();
        return new PemSecrets(certificateText, privateKeyText);
    }

    @VisibleForTesting
    public record PemSecrets(String certificate, String privateKey) {
        public static String keyIdentifier(long id) {
            return id + "-pemPrivateKey";
        }

        public static String certIdentifier(long id) {
            return id + "-pemCertificate";
        }
    }
}

