/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.search.hibernate;

import com.atlassian.crowd.model.InternalEntityAttribute;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.ImmutableDirectoryGroup;
import com.atlassian.crowd.model.group.ImmutableDirectoryGroupWithAttributes;
import com.atlassian.crowd.model.group.ImmutableGroup;
import com.atlassian.crowd.model.group.InternalDirectoryGroup;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.model.user.BaseImmutableUser;
import com.atlassian.crowd.model.user.ImmutableTimestampedUser;
import com.atlassian.crowd.model.user.ImmutableTimestampedUserWithAttributes;
import com.atlassian.crowd.model.user.ImmutableUser;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.hibernate.CustomDataFetcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CustomDataFetchers {
    private static final String DIRECTORY_ID = "directory.id";
    private static final String GROUP_TYPE = "type";
    private static final String ACTIVE = "active";
    private static final String FIRST_NAME = "firstName";
    private static final String LAST_NAME = "lastName";
    private static final String DISPLAY_NAME = "displayName";
    private static final String EMAIL = "emailAddress";
    private static final String DESCRIPTION = "description";
    private static final String EXTERNAL_ID = "externalId";
    private static final String CREATED_DATE = "createdDate";
    private static final String UPDATED_DATE = "updatedDate";
    private static final String LOCAL = "local";
    private static final CustomDataFetcher<?> NO_OP = new CustomDataFetcher(){

        @Override
        public List<String> attributes(String alias) {
            return Collections.singletonList(alias);
        }

        public Function<Object[], ?> getTransformer(int start) {
            return values -> values[start];
        }
    };
    private static final Map<Class<? extends User>, CustomDataFetcher<?>> USER_PRODUCERS = new LinkedHashMap();
    private static final Map<Class<? extends Group>, CustomDataFetcher<?>> GROUP_PRODUCERS;
    private static final ConcurrentHashMap<Class<?>, CustomDataFetcher<?>> CACHE;

    private CustomDataFetchers() {
    }

    public static <T> CustomDataFetcher<T> entityProducer(Class<T> returnType) {
        return CACHE.computeIfAbsent(returnType, key -> Stream.of(USER_PRODUCERS, GROUP_PRODUCERS).flatMap(e -> e.entrySet().stream()).filter(entry -> returnType.isAssignableFrom((Class)entry.getKey())).findFirst().map(entry -> (CustomDataFetcher)entry.getValue()).orElse(NO_OP));
    }

    private static CustomDataFetcher<ImmutableTimestampedUserWithAttributes> createImmutableTimestampedUserWithAttributesProducer() {
        return new CustomDataFetcher<ImmutableTimestampedUserWithAttributes>(){

            @Override
            public List<String> attributes(String alias) {
                return Collections.singletonList(alias);
            }

            @Override
            public Function<Object[], ImmutableTimestampedUserWithAttributes> getTransformer(int start) {
                IdentityHashMap cache = new IdentityHashMap();
                return values -> cache.computeIfAbsent((InternalUser)((Object)((Object)values[start])), this::transform);
            }

            private ImmutableTimestampedUserWithAttributes transform(InternalUser user) {
                return ImmutableTimestampedUserWithAttributes.builder((TimestampedUser)user, InternalEntityAttribute.toMap(user.getAttributes())).build();
            }
        };
    }

    private static CustomDataFetcher<ImmutableDirectoryGroupWithAttributes> createImmutableDirectoryGroupWithAttributesProducer() {
        return new CustomDataFetcher<ImmutableDirectoryGroupWithAttributes>(){

            @Override
            public List<String> attributes(String alias) {
                return Collections.singletonList(alias);
            }

            @Override
            public Function<Object[], ImmutableDirectoryGroupWithAttributes> getTransformer(int start) {
                IdentityHashMap cache = new IdentityHashMap();
                return values -> cache.computeIfAbsent((InternalGroup)((Object)((Object)values[start])), this::transform);
            }

            private ImmutableDirectoryGroupWithAttributes transform(InternalGroup group) {
                return ImmutableDirectoryGroupWithAttributes.builder((InternalDirectoryGroup)group, InternalEntityAttribute.toMap(group.getAttributes())).build();
            }
        };
    }

    private static CustomDataFetcher<ImmutableDirectoryGroup> createImmutableDirectoryGroupProducer() {
        SetterBuilder<ImmutableDirectoryGroup.Builder> setters = new SetterBuilder<ImmutableDirectoryGroup.Builder>();
        setters.put(DIRECTORY_ID, (rec$, x$0) -> {
            ImmutableDirectoryGroup.Builder cfr_ignored_0 = (ImmutableDirectoryGroup.Builder)((ImmutableDirectoryGroup.Builder)rec$).setDirectoryId(x$0);
        });
        setters.put(GROUP_TYPE, (rec$, x$0) -> {
            ImmutableDirectoryGroup.Builder cfr_ignored_0 = (ImmutableDirectoryGroup.Builder)((ImmutableDirectoryGroup.Builder)rec$).setType(x$0);
        });
        setters.put(ACTIVE, (rec$, x$0) -> {
            ImmutableDirectoryGroup.Builder cfr_ignored_0 = (ImmutableDirectoryGroup.Builder)((ImmutableDirectoryGroup.Builder)rec$).setActive(x$0);
        });
        setters.put(DESCRIPTION, (rec$, x$0) -> {
            ImmutableDirectoryGroup.Builder cfr_ignored_0 = (ImmutableDirectoryGroup.Builder)((ImmutableDirectoryGroup.Builder)rec$).setDescription(x$0);
        });
        setters.put(EXTERNAL_ID, (rec$, x$0) -> {
            ImmutableDirectoryGroup.Builder cfr_ignored_0 = (ImmutableDirectoryGroup.Builder)((ImmutableDirectoryGroup.Builder)rec$).setExternalId(x$0);
        });
        setters.put(LOCAL, ImmutableDirectoryGroup.Builder::setLocal);
        setters.put(CREATED_DATE, ImmutableDirectoryGroup.Builder::setCreatedDate);
        setters.put(UPDATED_DATE, ImmutableDirectoryGroup.Builder::setUpdatedDate);
        return CustomDataFetchers.create(ImmutableDirectoryGroup::builder, ImmutableDirectoryGroup.Builder::build, setters);
    }

    private static CustomDataFetcher<ImmutableGroup> createImmutableGroupProducer() {
        SetterBuilder<ImmutableGroup.Builder> setters = new SetterBuilder<ImmutableGroup.Builder>();
        setters.put(DIRECTORY_ID, ImmutableGroup.Builder::setDirectoryId);
        setters.put(GROUP_TYPE, ImmutableGroup.Builder::setType);
        setters.put(ACTIVE, ImmutableGroup.Builder::setActive);
        setters.put(DESCRIPTION, ImmutableGroup.Builder::setDescription);
        setters.put(EXTERNAL_ID, ImmutableGroup.Builder::setExternalId);
        return CustomDataFetchers.create(ImmutableGroup::builder, ImmutableGroup.Builder::build, setters);
    }

    private static CustomDataFetcher<ImmutableTimestampedUser> crateImmutableTimestampedUserProducer() {
        SetterBuilder<ImmutableTimestampedUser.Builder> setters = new SetterBuilder<ImmutableTimestampedUser.Builder>();
        setters.put(DIRECTORY_ID, BaseImmutableUser.Builder::directoryId);
        setters.put(DISPLAY_NAME, BaseImmutableUser.Builder::displayName);
        setters.put(EMAIL, BaseImmutableUser.Builder::emailAddress);
        setters.put(ACTIVE, BaseImmutableUser.Builder::active);
        setters.put(FIRST_NAME, BaseImmutableUser.Builder::firstName);
        setters.put(LAST_NAME, BaseImmutableUser.Builder::lastName);
        setters.put(EXTERNAL_ID, BaseImmutableUser.Builder::externalId);
        setters.put(CREATED_DATE, ImmutableTimestampedUser.Builder::createdDate);
        setters.put(UPDATED_DATE, ImmutableTimestampedUser.Builder::updatedDate);
        return CustomDataFetchers.create(ImmutableTimestampedUser::builder, ImmutableTimestampedUser.Builder::build, setters);
    }

    private static CustomDataFetcher<ImmutableUser> createImmutableUserProducer() {
        SetterBuilder<ImmutableUser.Builder> setters = new SetterBuilder<ImmutableUser.Builder>();
        setters.put(DIRECTORY_ID, BaseImmutableUser.Builder::directoryId);
        setters.put(DISPLAY_NAME, BaseImmutableUser.Builder::displayName);
        setters.put(EMAIL, BaseImmutableUser.Builder::emailAddress);
        setters.put(ACTIVE, BaseImmutableUser.Builder::active);
        setters.put(FIRST_NAME, BaseImmutableUser.Builder::firstName);
        setters.put(LAST_NAME, BaseImmutableUser.Builder::lastName);
        setters.put(EXTERNAL_ID, BaseImmutableUser.Builder::externalId);
        return CustomDataFetchers.create(ImmutableUser::builder, ImmutableUser.Builder::build, setters);
    }

    private static <T, Q> CustomDataFetcher<Q> create(final Function<String, T> fromNameBuilder, final Function<T, Q> buildSupplier, SetterBuilder<T> setterBuilder) {
        final LinkedHashMap immutableSetters = new LinkedHashMap(setterBuilder.setters);
        final ArrayList<String> attributes = new ArrayList<String>();
        attributes.add("id");
        attributes.add("name");
        attributes.addAll(immutableSetters.keySet());
        return new CustomDataFetcher<Q>(){

            @Override
            public List<String> attributes(String alias) {
                return attributes.stream().map(att -> alias + "." + att).collect(Collectors.toList());
            }

            @Override
            public Function<Object[], Q> getTransformer(int start) {
                HashMap cache = new HashMap();
                return values -> cache.computeIfAbsent(values[start], id -> this.transform((Object[])values, start + 1));
            }

            private Q transform(Object[] values, int start) {
                int idx = start;
                Object builder = fromNameBuilder.apply((String)values[idx++]);
                for (BiConsumer setter : immutableSetters.values()) {
                    setter.accept(builder, values[idx++]);
                }
                return buildSupplier.apply(builder);
            }
        };
    }

    static {
        USER_PRODUCERS.put(ImmutableTimestampedUser.class, CustomDataFetchers.crateImmutableTimestampedUserProducer());
        USER_PRODUCERS.put(ImmutableUser.class, CustomDataFetchers.createImmutableUserProducer());
        USER_PRODUCERS.put(ImmutableTimestampedUserWithAttributes.class, CustomDataFetchers.createImmutableTimestampedUserWithAttributesProducer());
        GROUP_PRODUCERS = new LinkedHashMap();
        GROUP_PRODUCERS.put(ImmutableDirectoryGroup.class, CustomDataFetchers.createImmutableDirectoryGroupProducer());
        GROUP_PRODUCERS.put(ImmutableGroup.class, CustomDataFetchers.createImmutableGroupProducer());
        GROUP_PRODUCERS.put(ImmutableDirectoryGroupWithAttributes.class, CustomDataFetchers.createImmutableDirectoryGroupWithAttributesProducer());
        CACHE = new ConcurrentHashMap();
    }

    private static class SetterBuilder<T> {
        Map<String, BiConsumer<T, Object>> setters = new LinkedHashMap<String, BiConsumer<T, Object>>();

        private SetterBuilder() {
        }

        <Q> void put(String property, BiConsumer<T, Q> consumer) {
            this.setters.put(property, (entity, value) -> consumer.accept(entity, value));
        }
    }
}

