/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.watch;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Path(value="/watchState")
@Produces(value={"application/json"})
public class WatchStateResource {
    private final NotificationManager notificationManager;
    private final PermissionManager permissionManager;
    private final ContentEntityManager contentEntityManager;

    @Inject
    public WatchStateResource(@ComponentImport NotificationManager notificationManager, @ComponentImport PermissionManager permissionManager, @ComponentImport ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
        this.notificationManager = Objects.requireNonNull(notificationManager);
        this.permissionManager = Objects.requireNonNull(permissionManager);
    }

    @GET
    @Path(value="/{contentId}")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getWatchState(@PathParam(value="contentId") long contentId) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return Optional.ofNullable(this.contentEntityManager.getById(contentId)).filter(content -> content instanceof SpaceContentEntityObject).filter(content -> this.permissionManager.hasPermission(user, Permission.VIEW, content)).map(content -> (SpaceContentEntityObject)content).map(content -> Response.ok(this.buildWatchState(user, (SpaceContentEntityObject)content))).orElse(Response.status((Response.Status)Response.Status.NOT_FOUND)).build();
    }

    @VisibleForTesting
    Map<String, Boolean> buildWatchState(ConfluenceUser user, SpaceContentEntityObject content) {
        Space space = ((SpaceContentEntityObject)content.getLatestVersion()).getSpace();
        return ImmutableMap.of((Object)"watchingPage", (Object)this.notificationManager.isWatchingContent((User)user, (ContentEntityObject)content), (Object)"watchingSpace", (Object)(this.notificationManager.getNotificationByUserAndSpace((User)user, space) != null ? 1 : 0), (Object)"watchingBlogs", (Object)(this.notificationManager.getNotificationByUserAndSpaceAndType((User)user, space, ContentTypeEnum.BLOG) != null ? 1 : 0), (Object)"isAdmin", (Object)this.permissionManager.hasPermission(user, Permission.ADMINISTER, (Object)space), (Object)"isBlogPost", (Object)(content instanceof BlogPost));
    }
}

