/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.cors;

import com.atlassian.plugins.rest.api.internal.security.cors.CorsDefaults;
import com.atlassian.plugins.rest.api.internal.security.cors.CorsHeaders;
import com.atlassian.plugins.whitelist.InboundWhitelist;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class WhitelistBasedCorsDefaults
implements CorsDefaults {
    private static final Set<String> ALLOWED_REQUEST_HEADERS = Set.of("X-Atlassian-Token", "Authorization", "Content-Type");
    private static final Set<String> ALLOWED_RESPONSE_HEADERS = Set.of(CorsHeaders.ORIGIN.value(), "Authorization", "Content-Type");
    private final InboundWhitelist inboundWhitelist;

    public WhitelistBasedCorsDefaults(InboundWhitelist inboundWhitelist) {
        this.inboundWhitelist = inboundWhitelist;
    }

    public boolean allowsCredentials(String origin) throws IllegalArgumentException {
        return this.allowsOrigin(origin);
    }

    public boolean allowsOrigin(String origin) throws IllegalArgumentException {
        URI originUri;
        if (StringUtils.isBlank((CharSequence)origin)) {
            return false;
        }
        try {
            originUri = new URI(origin);
        }
        catch (URISyntaxException e) {
            return false;
        }
        return this.inboundWhitelist.isAllowed(originUri);
    }

    public Set<String> getAllowedRequestHeaders(String origin) throws IllegalArgumentException {
        return ALLOWED_REQUEST_HEADERS;
    }

    public Set<String> getAllowedResponseHeaders(String origin) throws IllegalArgumentException {
        return ALLOWED_RESPONSE_HEADERS;
    }
}

