/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.core;

import com.atlassian.sal.api.user.UserKey;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;

class WhitelistInput {
    private final URI uri;
    private final UserKey userKey;
    private final boolean skipAuthCheck;

    public WhitelistInput(URI uri, @Nullable UserKey userKey, boolean skipAuthCheck) {
        this.uri = Objects.requireNonNull(uri);
        this.userKey = userKey;
        this.skipAuthCheck = skipAuthCheck;
    }

    public URI getUri() {
        return this.uri;
    }

    public Optional<UserKey> getUserKey() {
        return Optional.ofNullable(this.userKey);
    }

    public boolean shouldSkipAuthCheck() {
        return this.skipAuthCheck;
    }
}

