/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.core;

import com.atlassian.plugins.whitelist.WhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistType;
import java.util.Objects;
import java.util.function.Predicate;

public class WhitelistRulePredicates {
    private WhitelistRulePredicates() {
    }

    public static Predicate<WhitelistRule> withId(int id) {
        return input -> {
            Integer whitelistRuleId = input != null ? input.getId() : null;
            return whitelistRuleId != null && id == whitelistRuleId;
        };
    }

    public static Predicate<WhitelistRule> withType(WhitelistType type) {
        Objects.requireNonNull(type, "type");
        return input -> input != null && type == input.getType();
    }

    public static Predicate<WhitelistRule> withExpression(String expression) {
        Objects.requireNonNull(expression, "expression");
        return input -> input != null && expression.equals(input.getExpression());
    }
}

