/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.core.applinks;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.plugins.whitelist.WhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistType;
import java.util.Objects;

public class ApplicationLinkWhitelistRule
implements WhitelistRule {
    private final ReadOnlyApplicationLink applicationLink;
    private final boolean authenticationRequired;

    public ApplicationLinkWhitelistRule(ReadOnlyApplicationLink applicationLink, boolean authenticationRequired) {
        this.applicationLink = Objects.requireNonNull(applicationLink, "applicationLink");
        this.authenticationRequired = authenticationRequired;
    }

    public Integer getId() {
        return null;
    }

    public String getExpression() {
        return ApplicationLinkWhitelistRule.getExpressionFrom(this.applicationLink);
    }

    public WhitelistType getType() {
        return WhitelistType.APPLICATION_LINK;
    }

    public boolean isAllowInbound() {
        return true;
    }

    public boolean isAuthenticationRequired() {
        return this.authenticationRequired;
    }

    public static String getExpressionFrom(ApplicationId applicationId) {
        Objects.requireNonNull(applicationId, "applicationId");
        return applicationId.get();
    }

    public static String getExpressionFrom(ReadOnlyApplicationLink applicationLink) {
        Objects.requireNonNull(applicationLink, "applicationLink");
        return ApplicationLinkWhitelistRule.getExpressionFrom(applicationLink.getId());
    }
}

