/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.core.matcher;

import com.atlassian.plugins.whitelist.core.matcher.MatcherUtils;
import com.atlassian.plugins.whitelist.core.matcher.exception.URINormalizationException;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.function.Predicate;

public class DomainNameMatcher
implements Predicate<URI> {
    private final String expression;

    public DomainNameMatcher(String expression) {
        this.expression = (String)Preconditions.checkNotNull((Object)expression, (Object)"expression");
    }

    @Override
    public boolean test(URI uri) {
        try {
            URI normalizedUri = MatcherUtils.normalizeUri(uri);
            return this.expression.equalsIgnoreCase(normalizedUri.getScheme() + "://" + normalizedUri.getAuthority());
        }
        catch (URINormalizationException e) {
            return false;
        }
    }
}

