/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.core.matcher;

import com.atlassian.plugins.whitelist.core.matcher.MatcherUtils;
import com.atlassian.plugins.whitelist.core.matcher.exception.URINormalizationException;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.function.Predicate;

public class ExactUrlMatcher
implements Predicate<URI> {
    private final URI expression;

    public ExactUrlMatcher(String expression) {
        this.expression = MatcherUtils.normalizeUriWithQuery(URI.create((String)Preconditions.checkNotNull((Object)expression, (Object)"expression")));
    }

    @Override
    public boolean test(URI uri) {
        try {
            URI normalizedUri = MatcherUtils.normalizeUriWithQuery(uri);
            return this.expression.equals(normalizedUri);
        }
        catch (URINormalizationException e) {
            return false;
        }
    }
}

