/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.core.matcher;

import com.atlassian.plugins.whitelist.core.matcher.exception.URINormalizationException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.utils.URIBuilder;

public class MatcherUtils {
    public static URI normalizeUri(URI uri) {
        try {
            return MatcherUtils.toNormalizedBuilder(uri).build();
        }
        catch (URISyntaxException e) {
            throw URINormalizationException.couldNotNormalize(uri, e);
        }
    }

    public static URI normalizeUriWithQuery(URI uri) {
        try {
            return MatcherUtils.toNormalizedBuilder(uri).setCustomQuery(uri.getQuery()).build();
        }
        catch (URISyntaxException e) {
            throw URINormalizationException.couldNotNormalize(uri, e);
        }
    }

    private static URIBuilder toNormalizedBuilder(URI uri) throws URISyntaxException {
        MatcherUtils.validateSchemePresent(uri);
        MatcherUtils.validateHostPresent(uri);
        return new URIBuilder().setScheme(uri.getScheme().toLowerCase()).setHost(uri.getHost().toLowerCase()).setPort(uri.getPort()).setPath(uri.getPath());
    }

    private static void validateHostPresent(URI uri) throws URISyntaxException {
        if (uri.getHost() == null) {
            int index = uri.getScheme().length() + "://".length();
            throw new URISyntaxException(uri.toString(), "Expected host at index " + index + ": " + String.valueOf(uri), index);
        }
    }

    private static void validateSchemePresent(URI uri) throws URISyntaxException {
        if (uri.getScheme() == null) {
            throw new URISyntaxException(uri.toString(), "Expected scheme at index 0: " + String.valueOf(uri), 0);
        }
    }

    public static boolean compare(URI base, URI supplied) {
        try {
            URI normalizedUri = MatcherUtils.normalizeUriWithQuery(supplied);
            return base.getHost().equals(normalizedUri.getHost()) && base.getScheme().equals(normalizedUri.getScheme()) && base.getPort() == normalizedUri.getPort() && supplied.getPath().startsWith(base.getPath());
        }
        catch (URINormalizationException e) {
            return false;
        }
    }

    public static boolean compare(String base, URI supplied) {
        return MatcherUtils.compare(URI.create(base), supplied);
    }
}

