/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.core.matcher;

import com.atlassian.plugins.whitelist.core.matcher.MatcherUtils;
import com.atlassian.plugins.whitelist.core.matcher.exception.URINormalizationException;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class RegularExpressionMatcher
implements Predicate<URI> {
    private final Pattern pattern;
    private final boolean containsQueryParameters;

    public RegularExpressionMatcher(String expression) {
        this.pattern = Pattern.compile((String)Preconditions.checkNotNull((Object)expression, (Object)"expression"));
        this.containsQueryParameters = expression.contains("\\?");
    }

    @Override
    public boolean test(URI uri) {
        try {
            URI normalizedUri = this.containsQueryParameters ? MatcherUtils.normalizeUriWithQuery(uri) : MatcherUtils.normalizeUri(uri);
            return this.pattern.matcher(normalizedUri.toString()).matches();
        }
        catch (URINormalizationException e) {
            return false;
        }
    }
}

