/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.core.matcher;

import com.atlassian.plugins.whitelist.core.matcher.MatcherUtils;
import com.atlassian.plugins.whitelist.core.matcher.exception.URINormalizationException;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class WildcardExpressionMatcher
implements Predicate<URI> {
    private static final String[] RULE_ESCAPE_CHARACTERS = new String[]{".", "?", "+", "|", "[", "]"};
    private static final String WILDCARD_CHARACTER_PATTERN = ".*";
    private final Pattern pattern;
    private final boolean containsQueryParameters;

    public WildcardExpressionMatcher(String expression) {
        this.pattern = Pattern.compile(WildcardExpressionMatcher.createRegex((String)Preconditions.checkNotNull((Object)expression, (Object)"expression")), 2);
        this.containsQueryParameters = expression.contains("?");
    }

    @Override
    public boolean test(URI uri) {
        try {
            URI normalizedUri = this.containsQueryParameters ? MatcherUtils.normalizeUriWithQuery(uri) : MatcherUtils.normalizeUri(uri);
            return this.pattern.matcher(normalizedUri.toString()).matches();
        }
        catch (URINormalizationException e) {
            return false;
        }
    }

    private static String createRegex(String rule) {
        String regex = rule;
        for (String escapeChar : RULE_ESCAPE_CHARACTERS) {
            regex = regex.replaceAll("\\" + escapeChar, "\\\\" + escapeChar);
        }
        return regex.replaceAll("\\*", WILDCARD_CHARACTER_PATTERN);
    }
}

