/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.core.migration;

import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.applinks.api.ReadOnlyApplicationLinkService;
import com.atlassian.plugins.whitelist.WhitelistManager;
import com.atlassian.plugins.whitelist.core.applinks.ApplicationLinkWhitelistRule;
import com.atlassian.plugins.whitelist.core.migration.AbstractWhitelistPluginUpgradeTask;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.StreamSupport;

public class ApplicationLinksMigration
extends AbstractWhitelistPluginUpgradeTask {
    private final ReadOnlyApplicationLinkService applicationLinkService;
    private final WhitelistManager whitelistManager;
    private final TransactionTemplate transactionTemplate;

    public ApplicationLinksMigration(ReadOnlyApplicationLinkService applicationLinkService, WhitelistManager whitelistManager, TransactionTemplate transactionTemplate) {
        this.applicationLinkService = applicationLinkService;
        this.whitelistManager = whitelistManager;
        this.transactionTemplate = transactionTemplate;
    }

    public int getBuildNumber() {
        return 1;
    }

    public String getShortDescription() {
        return "Migrate existing application links to the whitelist.";
    }

    public Collection<Message> doUpgrade() throws Exception {
        return (Collection)this.transactionTemplate.execute(() -> {
            Iterable applicationLinks = this.applicationLinkService.getApplicationLinks();
            this.whitelistManager.addAll(StreamSupport.stream(applicationLinks.spliterator(), false).map(applicationLink -> new ApplicationLinkWhitelistRule((ReadOnlyApplicationLink)applicationLink, false)).toList());
            return Collections.emptyList();
        });
    }
}

