/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.core.migration.confluence.macros;

import com.atlassian.plugins.whitelist.LegacyWhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistRule;
import com.atlassian.plugins.whitelist.core.migration.confluence.macros.BandanaMacroWhitelistXmlData;
import com.atlassian.security.xml.SecureXmlParserFactory;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class BandanaMacroWhitelistXmlParser {
    private static final boolean WHITELIST_ACTIVATED_BY_DEFAULT = true;
    private final SAXReader saxReader = new SAXReader(SecureXmlParserFactory.newXmlReader());

    public BandanaMacroWhitelistXmlParser() {
        this.saxReader.setEntityResolver(SecureXmlParserFactory.emptyEntityResolver());
    }

    public BandanaMacroWhitelistXmlData parseData(String xml) {
        if (StringUtils.isNotEmpty((CharSequence)xml)) {
            Document document = this.parseDocument(Objects.requireNonNull(xml, "xml"));
            return new BandanaMacroWhitelistXmlData(this.isAllowAll(document), this.getAcceptRules(document));
        }
        return new BandanaMacroWhitelistXmlData(true, Collections.emptyList());
    }

    private Document parseDocument(String xml) {
        try {
            return this.saxReader.read((Reader)new StringReader(xml));
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isAllowAll(Document document) {
        Node node = document.selectSingleNode("//allowAll/text()");
        return node != null && Boolean.parseBoolean(node.getStringValue());
    }

    private Collection<WhitelistRule> getAcceptRules(Document document) {
        List nodeList = document.selectNodes("//acceptRules/string");
        return nodeList.stream().map(this.transformNodeToWhitelistRule()).filter(Objects::nonNull).toList();
    }

    private Function<Node, WhitelistRule> transformNodeToWhitelistRule() {
        return input -> {
            if (input == null) {
                return null;
            }
            String textContent = input.getText();
            if (StringUtils.isEmpty((CharSequence)textContent)) {
                return null;
            }
            return new LegacyWhitelistRule(textContent);
        };
    }
}

