/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.core.spring;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.plugins.osgi.javaconfig.ExportOptions;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.JiraOnly;
import com.atlassian.plugins.whitelist.WhitelistManager;
import com.atlassian.plugins.whitelist.WhitelistOnOffSwitch;
import com.atlassian.plugins.whitelist.core.caching.GadgetsClearHttpCacheAdapter;
import com.atlassian.plugins.whitelist.core.caching.JiraClearCacheEventAdapter;
import com.atlassian.plugins.whitelist.core.migration.jira.JiraWhitelistMigration;
import com.atlassian.plugins.whitelist.core.permission.JiraPermissionChecker;
import com.atlassian.plugins.whitelist.core.permission.PermissionChecker;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={JiraOnly.class})
public class JiraBeans {
    @Bean
    PermissionManager permissionManager() {
        return OsgiServices.importOsgiService(PermissionManager.class);
    }

    @Bean
    JiraAuthenticationContext jiraAuthenticationContext() {
        return OsgiServices.importOsgiService(JiraAuthenticationContext.class);
    }

    @Bean(value={"jiraApplicationProperties"})
    ApplicationProperties applicationProperties() {
        return OsgiServices.importOsgiService(ApplicationProperties.class);
    }

    @Bean
    PermissionChecker jiraPermissionChecker() {
        return new JiraPermissionChecker(this.jiraAuthenticationContext(), this.permissionManager());
    }

    @Bean
    GadgetsClearHttpCacheAdapter gadgetsClearHttpCacheAdapter(EventPublisher eventPublisher) {
        return new GadgetsClearHttpCacheAdapter(eventPublisher);
    }

    @Bean
    JiraClearCacheEventAdapter jiraClearCacheEventAdapter(EventPublisher eventPublisher) {
        return new JiraClearCacheEventAdapter(eventPublisher);
    }

    @Bean
    FactoryBean<ServiceRegistration> jiraWhitelistMigration(ApplicationProperties applicationProperties, WhitelistManager whitelistManager, TransactionTemplate transactionTemplate, WhitelistOnOffSwitch whitelistOnOffSwitch) {
        return OsgiServices.exportOsgiService(new JiraWhitelistMigration(applicationProperties, whitelistManager, transactionTemplate, whitelistOnOffSwitch), ExportOptions.as(PluginUpgradeTask.class, new Class[0]));
    }
}

