/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.core.spring;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.applinks.api.ReadOnlyApplicationLinkService;
import com.atlassian.cache.CacheManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.cors.WhitelistBasedCorsDefaults;
import com.atlassian.plugins.osgi.javaconfig.ExportOptions;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.BambooOnly;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.BitbucketOnly;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.ConfluenceOnly;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.CrowdOnly;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.FecruOnly;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.RefappOnly;
import com.atlassian.plugins.rest.api.internal.security.cors.CorsDefaults;
import com.atlassian.plugins.whitelist.AccessManager;
import com.atlassian.plugins.whitelist.InboundWhitelist;
import com.atlassian.plugins.whitelist.OutboundWhitelist;
import com.atlassian.plugins.whitelist.WhitelistManager;
import com.atlassian.plugins.whitelist.WhitelistOnOffSwitch;
import com.atlassian.plugins.whitelist.WhitelistService;
import com.atlassian.plugins.whitelist.applinks.ApplicationLinkRestrictions;
import com.atlassian.plugins.whitelist.core.InboundWhitelistImpl;
import com.atlassian.plugins.whitelist.core.OutboundWhitelistImpl;
import com.atlassian.plugins.whitelist.core.WhitelistManagerImpl;
import com.atlassian.plugins.whitelist.core.WhitelistOnOffSwitchImpl;
import com.atlassian.plugins.whitelist.core.WhitelistServiceImpl;
import com.atlassian.plugins.whitelist.core.ao.AoWhitelistRuleDao;
import com.atlassian.plugins.whitelist.core.applinks.ApplicationLinkChangeListener;
import com.atlassian.plugins.whitelist.core.applinks.ApplicationLinkRestrictionsCache;
import com.atlassian.plugins.whitelist.core.applinks.ApplicationLinkRestrictionsImpl;
import com.atlassian.plugins.whitelist.core.matcher.SelfUrlMatcher;
import com.atlassian.plugins.whitelist.core.permission.DefaultPermissionChecker;
import com.atlassian.plugins.whitelist.core.permission.PermissionChecker;
import com.atlassian.plugins.whitelist.core.spring.ConfluenceBeans;
import com.atlassian.plugins.whitelist.core.spring.ImportedBeans;
import com.atlassian.plugins.whitelist.core.spring.JiraBeans;
import com.atlassian.plugins.whitelist.core.spring.UpgradeTaskBeans;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={ImportedBeans.class, ConfluenceBeans.class, JiraBeans.class, UpgradeTaskBeans.class})
public class SpringBeans {
    @Bean
    FactoryBean<ServiceRegistration> exportWhitelistService(WhitelistService whitelistService) {
        return OsgiServices.exportOsgiService(whitelistService, ExportOptions.as(WhitelistService.class, new Class[0]));
    }

    @Bean
    WhitelistService whitelistService(WhitelistOnOffSwitch whitelistOnOffSwitch, WhitelistManager whitelistManager, PermissionChecker permissionChecker, EventPublisher eventPublisher, CacheManager cacheManager) {
        return new WhitelistServiceImpl(whitelistOnOffSwitch, whitelistManager, permissionChecker, eventPublisher, cacheManager);
    }

    @Bean
    FactoryBean<ServiceRegistration> exportOutboundWhitelist(OutboundWhitelist outboundWhitelist) {
        return OsgiServices.exportOsgiService(outboundWhitelist, ExportOptions.as(OutboundWhitelist.class, new Class[0]));
    }

    @Bean
    OutboundWhitelist outboundWhitelist(WhitelistOnOffSwitch whitelistOnOffSwitch, WhitelistService whitelistService, SelfUrlMatcher selfUrlMatcher, ReadOnlyApplicationLinkService readOnlyApplicationLinkService, AccessManager accessManager) {
        return new OutboundWhitelistImpl(whitelistOnOffSwitch, whitelistService, selfUrlMatcher, readOnlyApplicationLinkService, accessManager);
    }

    @Bean
    FactoryBean<ServiceRegistration> exportInboundWhitelist(InboundWhitelist inboundWhitelist) {
        return OsgiServices.exportOsgiService(inboundWhitelist, ExportOptions.as(InboundWhitelist.class, new Class[0]));
    }

    @Bean
    InboundWhitelist inboundWhitelist(WhitelistOnOffSwitch whitelistOnOffSwitch, WhitelistService whitelistService, SelfUrlMatcher selfUrlMatcher, ReadOnlyApplicationLinkService readOnlyApplicationLinkService, AccessManager accessManager) {
        return new InboundWhitelistImpl(whitelistOnOffSwitch, whitelistService, selfUrlMatcher, readOnlyApplicationLinkService, accessManager);
    }

    @Bean
    ApplicationLinkChangeListener applicationLinkChangeListener(EventPublisher eventPublisher, WhitelistManager whitelistManager, TransactionTemplate transactionTemplate, ReadOnlyApplicationLinkService readOnlyApplicationLinkService, ApplicationLinkRestrictions applicationLinkRestrictions) {
        return new ApplicationLinkChangeListener(eventPublisher, whitelistManager, transactionTemplate, readOnlyApplicationLinkService, applicationLinkRestrictions);
    }

    @Bean
    WhitelistOnOffSwitch whitelistOnOffSwitch(PluginSettingsFactory pluginSettingsFactory, EventPublisher eventPublisher, CacheManager cacheManager) {
        return new WhitelistOnOffSwitchImpl(pluginSettingsFactory, eventPublisher, cacheManager);
    }

    @Bean
    WhitelistManager whitelistManager(AoWhitelistRuleDao aoWhitelistRuleDao, TransactionTemplate transactionTemplate, EventPublisher eventPublisher) {
        return new WhitelistManagerImpl(aoWhitelistRuleDao, transactionTemplate, eventPublisher);
    }

    @Bean
    SelfUrlMatcher selfUrlMatcher(ApplicationProperties applicationProperties) {
        return new SelfUrlMatcher(applicationProperties);
    }

    @Bean
    @Conditional(value={BambooOnly.class})
    PermissionChecker bambooPermissionChecker(UserManager userManager) {
        return new DefaultPermissionChecker(userManager);
    }

    @Bean
    @Conditional(value={BitbucketOnly.class})
    PermissionChecker bitbucketPermissionChecker(UserManager userManager) {
        return new DefaultPermissionChecker(userManager);
    }

    @Bean
    @Conditional(value={ConfluenceOnly.class})
    PermissionChecker confluencePermissionChecker(UserManager userManager) {
        return new DefaultPermissionChecker(userManager);
    }

    @Bean
    @Conditional(value={CrowdOnly.class})
    PermissionChecker crowdPermissionChecker(UserManager userManager) {
        return new DefaultPermissionChecker(userManager);
    }

    @Bean
    @Conditional(value={FecruOnly.class})
    PermissionChecker feCruPermissionChecker(UserManager userManager) {
        return new DefaultPermissionChecker(userManager);
    }

    @Bean
    @Conditional(value={RefappOnly.class})
    PermissionChecker refappPermissionChecker(UserManager userManager) {
        return new DefaultPermissionChecker(userManager);
    }

    @Bean
    FactoryBean<ServiceRegistration> exportWhitelistBasedCorsDefaults(WhitelistBasedCorsDefaults whitelistBasedCorsDefaults) {
        return OsgiServices.exportOsgiService(whitelistBasedCorsDefaults, ExportOptions.as(CorsDefaults.class, new Class[0]));
    }

    @Bean
    WhitelistBasedCorsDefaults whitelistBasedCorsDefaults(InboundWhitelist inboundWhitelist) {
        return new WhitelistBasedCorsDefaults(inboundWhitelist);
    }

    @Bean
    AoWhitelistRuleDao aoWhitelistRuleDao(ActiveObjects activeObjects) {
        return new AoWhitelistRuleDao(activeObjects);
    }

    @Bean
    ApplicationLinkRestrictionsCache applicationLinkRestrictionsCache(CacheManager cacheManager) {
        return new ApplicationLinkRestrictionsCache(cacheManager);
    }

    @Bean
    FactoryBean<ServiceRegistration> exportApplicationLinkRestrictions(ApplicationLinkRestrictions applicationLinkRestrictions) {
        return OsgiServices.exportOsgiService(applicationLinkRestrictions, ExportOptions.as(ApplicationLinkRestrictions.class, new Class[0]));
    }

    @Bean
    ApplicationLinkRestrictions applicationLinkRestrictions(PluginSettingsFactory pluginSettingsFactory, EventPublisher eventPublisher, ApplicationLinkRestrictionsCache applicationLinkRestrictionsCache, WhitelistManager whitelistManager, TransactionTemplate transactionTemplate) {
        return new ApplicationLinkRestrictionsImpl(pluginSettingsFactory, eventPublisher, applicationLinkRestrictionsCache, whitelistManager, transactionTemplate);
    }
}

