define('confluence/ob/flow/main/intro-flow', [
    'jquery',
    'ajs',
    'confluence/ob/common/common-core',
    'confluence/ob/modules/intro/intro-video-sequence',
    'confluence/ob/modules/intro/intro-create-space-sequence',
    'confluence/ob/modules/intro/intro-upload-avatar-sequence',
    'confluence/ob/modules/intro/intro-find-spaces-sequence',
    'confluence/ob/modules/intro/intro-sequence-utils',
    'confluence/ob/modules/intro/warm-editor-resources',
    'confluence/ob/flow/controller/session-progress-tracker'
], function ($, AJS, CommonCore, IntroVideoSequence, IntroCreateSpaceSequence,
        IntroUploadAvatarSequence, IntroFindSpacesSequence, StepUtils, warmEditorResources, SessionProgressTracker) {
    var TestEvaluator = require('confluence/ob/common/test-evaluator');

    'use strict';

    return function IntroWorkflow(complete) {
        var warming = getWarmingPromise();

        function getWarmingPromise(){
            try {
                return warmEditorResources();
            } catch( exception ){
                // return a resolved promise if there is any error.
                return $.when();
            }
        }

        function goToEditorTour(context) {
            $.when(complete(), warming).always(function() {
                sessionStorage.setItem('created-space-key', context.spaceKey);
                SessionProgressTracker.setCurrentFlowSequence("tutorialFlow", "editorTour");

                if (context.draftId) {
                    // window.location.origin doesn't work on IE9
                    window.location.href = [window.location.protocol, '//', window.location.host, AJS.contextPath(),
                        '/pages/resumedraft.action?draftId=', context.draftId].join('');
                } else {
                    // We're seeing this randomly happen in tests, to be safe we're falling back to createpage.action which will be slower
                    AJS.error("PageUtils.createPageDraft / DraftResource.generateDraft has failed and returned an undefined draft ID for spaceKey " + context.spaceKey);
                    window.location.href = [window.location.protocol, '//', window.location.host, AJS.contextPath(),
                        '/pages/createpage.action?spaceKey=', context.spaceKey, '&atl_token=', AJS.Meta.get('atl-token')].join('');
                }
            });
        }

        function completeAndGoToDashboard() {
            complete().then(function() {
                window.location.href = [window.location.protocol, '//', window.location.host, AJS.contextPath() + '/dashboard.action'].join('');
            });
        }

        function onFinishUploadAvatar() {
            if (StepUtils.hasStep('create-space')) {
                return 'createSpace';
            } else if (StepUtils.hasStep('find-spaces')) {
                return 'findSpaces';
            } else {
                completeAndGoToDashboard();
            }
        }

        var states = {
            video: {
                instance: new IntroVideoSequence(),
                resolve: "uploadAvatar"
            },
            uploadAvatar: {
                instance: new IntroUploadAvatarSequence(),
                resolve:  onFinishUploadAvatar,
                reject: onFinishUploadAvatar
            },
            findSpaces: {
                instance: new IntroFindSpacesSequence(),
                resolve: completeAndGoToDashboard,
                reject: completeAndGoToDashboard
            },
            createSpace: {
                instance: new IntroCreateSpaceSequence(),
                resolve: goToEditorTour,
                reject: completeAndGoToDashboard
            }
        };

        return {
            key: "introWorkflow",
            // since 6.14, we no longer show 'video' and 'uploadAvatar'
            start: 'createSpace',
            sequences: states
        };
    };
});
