UPM.define('CertificatesCollection',
    [
        'brace',
        'jquery',
        'underscore',
        'CertificateModel',
        'UpmAjax',
        'UpmEnvironment'
    ], function(Brace,
                $,
                _,
                CertificateModel,
                UpmAjax,
                environment) {

    return Brace.Collection.extend({

        model: CertificateModel,

        /**
         * Retrieves a list of certificates from the server.
         */
        getCertificates: function() {

            var url = environment.getResourceUrl('certificates');

            var promise = $.ajax({
                url: url,
                type: 'get',
                dataType: 'json'
            });

            promise.done(_.bind(function(result) {
                this.reset(result);
            }, this));

            promise.fail(_.bind(function(request) {
                UpmAjax.signalAjaxError(request);
            }, this));
        },

        /**
         * Returns a filtered list of certificates by their display name.
         *
         * @param keyword The keyword to filter by.
         * @returns {Array} A list of CertificateModels.
         */
        filterCertificatesByDisplayName: function(keyword) {
            return this.filter(function(certificate) {
                return certificate.getDisplayName().toLowerCase().indexOf(keyword.toLowerCase()) > -1;
            });
        }
    });
});