UPM.define('CertificatesPageView',
    [
        'jquery',
        'underscore',
        'brace',
        'CertificatesView'
    ], function($,
                _,
                Brace,
                CertificatesView) {

    function compareCertificateName(b1, b2) {
        var n1 = (b1.getDisplayName()).toLowerCase(),
            n2 = (b2.getDisplayName()).toLowerCase();
        return (n1 > n2) ? 1 : ((n1 < n2) ? -1 : 0);
    }

    return Brace.View.extend({

        events: {
            "keyup #upm-certificates-filter-box": "_filterCertificates"
        },

        initialize: function() {
            this.listenTo(this.model, "reset", this.render);
        },

        render: function() {
            this._renderCertificates(this.model.models);
            AJS.Binder.runBinders(this.$el);
            return this.$el;
        },

        /**
         * Renders certificates by delegating to existing code.
         *
         * @param {Array} certificates The list of certificate models to render
         * @private
         */
        _renderCertificates: function(certificates) {
            var sortedCertificates = certificates.sort(compareCertificateName);
            this.$el.find("#upm-certificate-bundles .upm-plugin-list").html(_.map(sortedCertificates, function(b) {
                return new CertificatesView({ model: b }).render().$el;
            }));
            this.$el.find('#upm-certificate-bundles').removeClass('hidden');
            this.$el.find("#upm-panel-osgi").addClass("loaded");
        },

        /**
         *
         * @param e
         * @private
         */
        _filterCertificates: function(e) {
            e.preventDefault();
            var keyword = $(e.target).val();
            var certificates = this.model.filterCertificatesByDisplayName(keyword);
            this._renderCertificates(certificates);
        }
    });
});