UPM.define('CertificatesView',
    [
        'jquery',
        'underscore',
        'BaseView',
        'CertificatesTemplate',
        'ExpandableViewMixin',
        'CertificateDetailsView',
        'CollectionItemRenderingStrategy'
    ], function($,
                _,
                BaseView,
                bundleTemplate,
                ExpandableViewMixin,
                CertificateDetailsView,
                CollectionItemRenderingStrategy) {

    "use strict";

    return BaseView.extend({
        mixins: [ ExpandableViewMixin ],
        template: bundleTemplate,
        renderingStrategy: CollectionItemRenderingStrategy,
        detailViewClass: CertificateDetailsView,

        events: {
            "click a.upm-module-toggle": "_toggleModule",
        },

        _getData: function() {
            return {
                certificate: this.model.toJSON(),
                expired: this.model.getDaysToExpiration() < 0,
                nearExpiration: this.model.getDaysToExpiration() < 30
            };
        },

        _initEvents: function() {
            this.listenTo(this.model, 'focus', this._onFocus);
        },

        _postRender: function() {
            this.$el.find('div.upm-plugin-row').on('click', _.bind(this._onRowClick, this));
        },

        _onFocus: function() {
            $(window).scrollTop(this.$el.offset().top - 10);
            this._expandDetails();
        },

        _toggleModule: function(e) {
            e.preventDefault();
            var target = $(e.target).blur();
            target.closest('div.upm-plugin-modules').toggleClass('expanded');
        }
    });
});
