/**
 * @module confluence-keyboard-shortcuts/tinymce-plugin
 */
define('confluence-keyboard-shortcuts/tinymce-plugin', [
    'confluence-keyboard-shortcuts/confluence-keyboard-shortcuts',
], function(KeyboardShortcutsObject) {
    'use strict';

    var KeyboardShortcutsPlugin = {};
    KeyboardShortcutsPlugin.init = function(ed) {
        var buildFormatFunction = function(format) {
            return function() {
                ed.execCommand('FormatBlock', false, format);
            };
        };
        for (var i = 1; i < 7; i++) {
            ed.addCommand('FormatBlock-h' + i, buildFormatFunction('h' + i));
        }
        ed.addCommand('FormatBlock-p', buildFormatFunction('p'));
        ed.addCommand('FormatBlock-pre', buildFormatFunction('pre'));
        ed.addCommand('FormatBlock-blockquote', buildFormatFunction('blockquote'));

        ed.addCommand('mceConfShortcutDialog', KeyboardShortcutsObject.keyboardShortcuts.openDialog);
        ed.ui.registry.addButton('help', {
            text: 'confluence.conf_shortcuts_help_desc',
            onAction: function() {
                ed.execCommand('mceConfShortcutDialog');
            }
        });
    };

    KeyboardShortcutsPlugin.getInfo = function() {
        return {
            longname: 'Atlassian Editor Keyboard Shortcuts Plugin',
            author: 'Atlassian',
            authorurl: 'http://www.atlassian.com',
        };
    };

    return function() {
        return KeyboardShortcutsPlugin;
    };
});

require('confluence/module-exporter').safeRequire('confluence-keyboard-shortcuts/tinymce-plugin', function(KeyboardShortcutsPlugin) {
    'use strict';

    var tinymce = require('tinymce');

    tinymce.PluginManager.add('keyboardshortcuts', KeyboardShortcutsPlugin);
});
