/**
 * This module is cloned from CONF master. Because our plugin want to support old version CONF
 * and also want to export several AMD modules as global variable to be compatible with legacy code.
 */
define('confluence/jim/amd/module-exporter', [], function () {
    'use strict';

    var ModuleExporter = {};

    /**
     * Get/set the value at a compound namespace, gracefully adding values where missing.
     * @param {string} namespace the dotted string for the namespace. Each component must be a valid js identifier
     * @param {Object} [value={}] the value to bind to the namespace, if it's not already defined
     * @param {Object} [context=window] the context to lookup and bind the namespace to
     * @returns {Object} the requested namespace
     * @deprecated please create AMD modules in the appropriate place in this plugin.
     */
    ModuleExporter.namespace = function (namespace, value, context) {
        var names = namespace.split(".");
        var ctx = context || window;
        var i;
        var n = names.length - 1;
        for (i = 0; i < n; i++) {
            var x = ctx[names[i]];
            ctx = (x != null) ? x : ctx[names[i]] = {};
        }
        if (ctx[names[i]]) {
            if (window.console && window.console.warn) {
                window.console.warn('Value of "' + namespace + '" was overridden');
            }
        }
        ctx[names[i]] = value || ctx[names[i]] || {};
        return ctx[names[i]];
    };

    /**
     * Wrapper function for AMD "require" that handles common error scenarios. This function is required in unit tests
     * when requiring a module in the same file where the module is defined (which usually throws an exception).
     *
     * @method safeRequire
     * @param {String} moduleName the module to require
     * @param {Function} [cb] callback
     * @returns {Object|undefined} undefined
     */
    ModuleExporter.safeRequire = function (moduleName, cb) {
        if (define && define.amd === undefined) {
            var module = require(moduleName);
            if (cb) {
                cb(module);
            }
        }
    };

    ModuleExporter.exportModuleAsGlobal = function (moduleName, namespace, cb) {
        ModuleExporter.safeRequire(moduleName, function (module) {
            ModuleExporter.namespace(namespace, module);
            if (cb) {
                cb(module);
            }
        });
    };

    return ModuleExporter;
});