AJS.Editor.JiraConnector.Panel.Search = function () {
    this.jql_operators = /=|!=|~|>|<|!~| is | in /i;
};
AJS.Editor.JiraConnector.Select2 = AJS.Editor.JiraConnector.Select2 || {};
AJS.Editor.JiraConnector.Panel.Search.prototype = AJS.$.extend(AJS.Editor.JiraConnector.Panel.Search.prototype, AJS.Editor.JiraConnector.Panel.prototype);
AJS.Editor.JiraConnector.Panel.Search.prototype = AJS.$.extend(AJS.Editor.JiraConnector.Panel.Search.prototype, {
    defaultColumns: 'key,summary,type,created,updated,due,assignee,reporter,priority,status,resolution',
    defaultColumnIds: 'issuekey,summary,issuetype,created,updated,duedate,assignee,reporter,priority,status,resolution',
    aliases: [{
        id: 'issuekey',
        clauseName: 'key'
    }, {
        id: 'issuetype',
        clauseName: 'type'
    }, {
        id: 'duedate',
        clauseName: 'due'
    }],
    DEFAULT_MAX_ISSUES_VAL: 20,
    MAXIMUM_MAX_ISSUES_VAL: 1000,
    MINIMUM_MAX_ISSUES_VAL: 1,
    title: function () {
        return AJS.I18n.getText('insert.jira.issue.search');
    },
    init: function (panel) {
        var FormStateControl = require('confluence/form-state-control');

        panel.html('<div id="my-jira-search"></div>');
        var thiz = this;
        var container = AJS.$('#my-jira-search');
        this.container = container;

        var clearPanel = function () {
            container.children(':not(div.jira-search-form)').remove();
        };

        var enableSearch = function () {
            FormStateControl.enableElement(AJS.$('input.text,button', container));
        };

        var disableSearch = function () {
            FormStateControl.disableElement(AJS.$('input.text,button', container));
        };

        var authCheck = function (server) {
            clearPanel();
            // disable insert when authCheck
            thiz.disableInsert();
            if (server) { thiz.selectedServer = server; }
            if (thiz.selectedServer.authUrl) {
                disableSearch();
                var oauthForm = thiz.createOauthForm(function () {
                    clearPanel();
                    enableSearch();
                });
                container.append(oauthForm);
            } else {
                enableSearch();
                AJS.$('.search-help').show();
            }
        };

        this.authCheck = authCheck;

        var doSearch = function (searchParams) {
            var searchValue = searchParams && searchParams.searchValue;
            var serverName = searchParams && searchParams.serverName;

            if (searchValue) {
                AJS.$('input:text', container).val(searchValue);
            }

            if (serverName && serverName != this.selectedServer.name) {
                var servers = AJS.Editor.JiraConnector.servers;
                var isServerExist = false;
                for (var i = 0; i < servers.length; i++) {
                    if (servers[i].name == serverName) {
                        AJS.$('option[value="' + servers[i].id + '"]', container).prop('selected', true);
                        AJS.$('select', container).change();
                        isServerExist = true;
                        break;
                    }
                }

                if (!isServerExist) {
                    showNoServerMessage(AJS.Meta.get('is-admin'));
                    return;
                }
            }

            if (this.currentXhr && this.currentXhr.readyState != 4) {
                return;
            }

            var queryTxt = searchValue || AJS.$('input', container).val();

            // analytics stuff
            if (AJS.Editor.JiraAnalytics) {
                var type = AJS.JQLHelper.checkQueryType(queryTxt);
                if (type) {
                    AJS.Editor.JiraAnalytics.triggerSearchEvent({
                        type: type,
                        source: 'dialog'
                    });
                }
            }

            var performQuery = function (jql, single, fourHundredHandler) {
                var $columnSelector = container.find('#jiraIssueColumnSelector');
                const jiraIssueColumnSelectorData = $columnSelector.auiSelect2 && $columnSelector.auiSelect2('data');
                const columnIdsSelected = !Array.isArray(jiraIssueColumnSelectorData) ? undefined :
                    jiraIssueColumnSelectorData.map(columns => columns.id);
                FormStateControl.disableElement(AJS.$('select', container));
                disableSearch();
                thiz.lastSearch = jql;
                thiz.createIssueTableFromUrl(container,
                    thiz.selectedServer.id,
                    '/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?jqlQuery=' + encodeURIComponent(jql) + '&returnMax=true&tempMax=20&field=summary&field=type&field=link',
                    thiz.selectHandler,
                    thiz.insertLinkFromForm,
                    function () { // <-- noRowsHandler
                        thiz.addDisplayOptionPanel();
                        thiz.loadMacroParams(columnIdsSelected);
                        thiz.bindEventToDisplayOptionPanel(true, searchParams); // still enable display option if the jql is legal but no results found
                        thiz.enableInsert();
                    },
                    function (totalIssues) {
                        thiz.addDisplayOptionPanel();
                        thiz.loadMacroParams(columnIdsSelected);
                        thiz.bindEventToDisplayOptionPanel(false, searchParams);
                        thiz.updateTotalIssuesDisplay(totalIssues);
                        thiz.checkAutoSelectColumns();
                        searchParams && searchParams.isAutoSearch && thiz.focusForm();
                    },
                    function (xhr) {
                        thiz.disableInsert();
                        if (xhr.status == 400) {
                            if (fourHundredHandler) {
                                fourHundredHandler();
                            } else {
                                AJS.$('div.data-table', container).remove();
                                thiz.warningMsg(container, AJS.I18n.getText('insert.jira.issue.search.badrequest', Confluence.Templates.ConfluenceJiraPlugin.learnMore()));
                            }
                        } else {
                            AJS.$('div.data-table', container).remove();
                            thiz.ajaxError(xhr, authCheck);
                        }
                        searchParams && searchParams.isAutoSearch && thiz.focusForm();
                    },
                    true); // <-- add checkbox column
            };

            if (AJS.JQLHelper.isFilterUrl(queryTxt)) {
                var url = decodeURIComponent(queryTxt);
                var serverIndex = AJS.JQLHelper.findServerIndexFromUrl(url, AJS.Editor.JiraConnector.servers);
                if (serverIndex != -1) {
                    var appLinkId = AJS.Editor.JiraConnector.servers[serverIndex].id;
                    AJS.$('option[value="' + appLinkId + '"]', container).prop('selected', true);
                    AJS.$('select', container).change();

                    var filterJql = AJS.JQLHelper.getFilterFromFilterUrl(url);
                    if (filterJql) {
                        AJS.$('input', container).val(filterJql);
                        performQuery(filterJql);
                    } else {
                        clearPanel();
                        thiz.warningMsg(container, AJS.I18n.getText('insert.jira.issue.search.badrequest', Confluence.Templates.ConfluenceJiraPlugin.learnMore()));
                    }
                } else {
                    clearPanel();
                    thiz.disableInsert();
                    showNoServerMessage(AJS.Meta.get('is-admin'));
                }
            }
            // url/url xml
            else if (AJS.JQLHelper.isIssueUrlOrXmlUrl(queryTxt)) {
                var url = decodeURIComponent(queryTxt);
                var jiraParams = AJS.JQLHelper.getJqlAndServerIndexFromUrl(url, AJS.Editor.JiraConnector.servers);
                if (processJiraParams(jiraParams)) {
                    AJS.$('input', container).val(jiraParams.jqlQuery);
                    performQuery(jiraParams.jqlQuery, false, null);
                }
            } else if (queryTxt.match(thiz.jql_operators)) {
                performQuery(queryTxt, false, null);
            } else {
                // issue keys are configurable in Jira so we can't reliably detect one here instead issue two queries.
                // The first will be as an issue key, and if Jira returns a 400 then it did not recognise the key so
                // we then try the second.
                if (AJS.JQLHelper.isSingleKeyJQLExp(queryTxt)) {
                    performQuery('key = ' + queryTxt, true);
                } else if (AJS.JQLHelper.isMultipleSingleKeyJQLExp(queryTxt)) {
                    performQuery('key in (' + queryTxt + ')', true);
                } else {
                    performQuery('summary ~ "' + queryTxt + '" OR description ~ "' + queryTxt + '"', false, null);
                }
            }
        };

        this.doSearch = doSearch;
        thiz.addSearchForm();

        var processJiraParams = function (jiraParams) {
            var jql;
            if (jiraParams.serverIndex != -1) {
                AJS.$('option[value="' + AJS.Editor.JiraConnector.servers[jiraParams.serverIndex].id + '"]', container).prop('selected', true);
                AJS.$('select', container).change();
                if (jiraParams.jqlQuery.length == 0) {
                    // show error msg for no JQL - CONFVN-79
                    clearPanel();
                    thiz.errorMsg(container, AJS.I18n.getText('insert.jira.issue.search.badrequest'));
                } else {
                    jql = jiraParams.jqlQuery;
                }
            } else {
                clearPanel();
                thiz.disableInsert();
                showNoServerMessage(AJS.Meta.get('is-admin'));
            }
            return jql;
        };
        thiz.processJiraParams = processJiraParams;

        var showNoServerMessage = function (isAdmin) {
            var message = Confluence.Templates.ConfluenceJiraPlugin.showMessageNoServer({
                isAdministrator: isAdmin,
                contextPath: Confluence.getContextPath()
            });
            thiz.noServerMsg(container, message);

            // bind click for call refresh applink select when user click on open applink config
            var open_applinks = AJS.$('#open_applinks');
            open_applinks.bind('click', function () {
                AJS.Editor.JiraConnector.clickConfigApplink = true;
                // refreshAppLink will be used when open dialog
                AJS.Editor.JiraConnector.refreshAppLink = function () {
                    thiz.refreshSearchForm();
                };
            });
        };

        thiz.bindPasteEvent();

        AJS.$(panel).select(function () {
            thiz.validate();
        });
        // add tipsy tooltip
        $(document).tooltip({
            live: '.jql-display-opts-open.disabled',
            title: function () {
                return AJS.$('.jql-display-opts-open.disabled').data('title');
            },
            gravity: 's', // Point the arrow to the top
            delayIn: 300,
            delayOut: 0
        });
    },

    focusForm: function () {
        AJS.$('input[name="jiraSearch"]', this.container).focus();
    },

    addSearchForm: function () {
        var thiz = this;
        thiz.container.empty();
        var servers = AJS.Editor.JiraConnector.servers;
        thiz.selectedServer = servers[0];
        var isMultiServer = false;
        if (servers.length > 1) {
            isMultiServer = true;
        }
        // get searchform from soy template
        var searchFormSoy = Confluence.Templates.ConfluenceJiraPlugin.searchForm({ isMultiServer: isMultiServer });
        var searchForm = AJS.$(searchFormSoy).appendTo(thiz.container);

        if (servers.length > 1) {
            var serverSelect = AJS.$('<select class="select" tabindex="0"></select>').insertAfter('div.search-input', searchForm);
            thiz.applinkServerSelect(serverSelect, thiz.authCheck);
        }
        thiz.authCheck(thiz.selectedServer);

        AJS.$('button', thiz.container).click(function () {
            thiz.doSearch();
        });
        thiz.setActionOnEnter(AJS.$('input.text', thiz.container), thiz.doSearch);
    },

    bindPasteEvent: function () {
        var thiz = this;
        AJS.$('#my-jira-search input:text').bind('paste', function () {
            var element = this;
            setTimeout(function () {
                var textSearch = AJS.$(element).val();
                if (AJS.JQLHelper.isFilterUrl(textSearch)) {
                    thiz.doSearch();
                } else if (AJS.JQLHelper.isIssueUrlOrXmlUrl(textSearch)) {
                    var url = decodeURIComponent(textSearch);
                    var jiraParams = AJS.JQLHelper.getJqlAndServerIndexFromUrl(url, AJS.Editor.JiraConnector.servers);
                    if (thiz.processJiraParams(jiraParams)) {
                        AJS.$(element).val(jiraParams.jqlQuery);
                        // for auto search when paste url
                        thiz.doSearch();
                    }
                }
            }, 100);
        });
    },

    refreshSearchForm: function () {
        this.container.empty();
        this.addSearchForm();
        this.bindPasteEvent();
    },

    validate: function (acceptNoResult, searchParams) {
        var container = this.container;
        var issueResult = AJS.$('input:checkbox[name=jira-issue]', container);
        var searchPanel = AJS.Editor.JiraConnector.Panel.Search.prototype;
        if (issueResult.length || acceptNoResult) {
            var selectedIssueCount = AJS.$('input:checkbox[name=jira-issue]:checked', container).length;
            if (selectedIssueCount > 0 || acceptNoResult) {
                searchPanel.enableInsert();
            } else {
                searchPanel.disableInsert();
            }
            searchPanel.changeInsertOptionStatus(selectedIssueCount, acceptNoResult, searchParams);
        } else {
            if (AJS.$('.jira-oauth-message-marker', container).length) {
                searchPanel.authCheck(this.selectedServer);
            }
            AJS.$('input', container).focus();
            searchPanel.disableInsert();
        }

        if (searchPanel.isInsertDisabled()) {
            return;
        }

        searchPanel.validateMaxIssues();
    },

    isValidMaxIssues: function (value) {
        return AJS.$.isNumeric(value) && (this.MINIMUM_MAX_ISSUES_VAL <= value && value <= this.MAXIMUM_MAX_ISSUES_VAL);
    },

    validateMaxIssues: function (e) {
        var $element = AJS.$('#jira-maximum-issues');

        function clearMaxIssuesWarning () {
            $element.next('#jira-max-number-error').remove();
        }

        function disableMaxIssuesTextBox () {
            $element.prop("disabled", true);
        }

        function enableMaxIssuesTextBox () {
            $element.prop("disabled", false);
        }

        function showMaxIssuesWarning () {
            clearMaxIssuesWarning();
            $element.after(Confluence.Templates.ConfluenceJiraPlugin.warningValMaxiumIssues());
        }

        switch (AJS.$('input:radio[name=insert-advanced]:checked').val()) {
            case 'insert-single':
            case 'insert-count':
                clearMaxIssuesWarning();
                disableMaxIssuesTextBox();
                break;
            case 'insert-table':
                var searchPanel = AJS.Editor.JiraConnector.Panel.Search.prototype;
                enableMaxIssuesTextBox();
                var value = $element.val();
                if (AJS.$.trim(value) === '') {
                    if (e && e.type === 'keyup') {
                        clearMaxIssuesWarning();
                        break;
                    }
                    if (e && e.type === 'blur') {
                        value = searchPanel.MAXIMUM_MAX_ISSUES_VAL;
                        $element.val(value);
                        break;
                    }
                }
                if (searchPanel.isValidMaxIssues(value)) {
                    clearMaxIssuesWarning();
                    searchPanel.enableInsert();
                } else {
                    // disable insert button when validate fail
                    showMaxIssuesWarning();
                    searchPanel.disableInsert();
                }
                break;
        }
    },
    customizedColumn: null,
    checkAndSetDefaultValueMaximumIssues: function (options) {
        if (!options) {
            AJS.log('Cannot set default value for Maximum Issues');
            return;
        }

        var element = options.element || AJS.$('#jira-maximum-issues');
        var defaultVal = options.defaultVal || this.MAXIMUM_MAX_ISSUES_VAL;
        var value = AJS.$.trim(element.val());
        if (value === '') {
            // set default value if user did not input anything
            element.val(defaultVal);
        }
    },
    setMacroParams: function (params) {
        this.macroParams = params;
    },
    getMacroParamsFromUserInput: function () {
        var thiz = this;
        // get value from dialog
        var isCount = ((AJS.$('input:radio[name=insert-advanced]:checked').val() == 'insert-count'));
        var options = [];
        var selectedIssueKeys = [];
        var unselectIssueKeys = [];
        var epicLinkField = [];
        var otherEpicFields = [];
        var macroInputParams = {};
        AJS.$('#my-jira-search .my-result.aui input:checkbox[name=jira-issue]').each(function (i) {
            var checkbox = AJS.$(this);
            if (checkbox.is(':checked')) {
                selectedIssueKeys[selectedIssueKeys.length] = checkbox.val();
            } else {
                unselectIssueKeys[unselectIssueKeys.length] = checkbox.val();
            }
        });

        if (isCount) {
            macroInputParams.count = 'true';
        } else {
            if (!AJS.Editor.JiraConnector.Panel.Search.jiraColumnSelectBox) {
                macroInputParams.columns = this.defaultColumns;
                macroInputParams.columnIds = this.defaultColumnIds;
                return;
            }

            options = AJS.Editor.JiraConnector.Panel.Search.jiraColumnSelectBox.select2('data');
            if (options.length) {
                macroInputParams.columns = options
                    .map(function (option) {
                        return thiz.selectedServer.columns
                            .find(function (column) {
                                return column.id === option.id;
                            }).custom
                            // CONFSERVER-60143: support column name with comma and semicolon
                            ? option.text
                                .replace(/%/g, encodeURIComponent('%'))
                                .replace(/,/g, encodeURIComponent(','))
                                .replace(/;/g, encodeURIComponent(';'))
                            : option.id;
                    })
                    // todo: this clause names mapping could be removed once backend could handle jira built-in field ids
                    .map(function (option) {
                        var aliasFound = thiz.aliases.find(function (alias) { return alias.id === option; });
                        return aliasFound ? aliasFound.clauseName : option;
                    })
                    .join(',');
                macroInputParams.columnIds = options
                    .map(function (option) { return option.id; })
                    .join(',');
                // This is to maintain old behavior. When the user selects "Epic Name", "Epic Colour" or "Epic Status",
                // we have to query by epic link id in order to get the related epic fields data.
                epicLinkField = thiz.selectedServer.columns.find(function (column) {
                    return column.clauseNames.find(function (name) {
                        var nameLowerCase = name.toLowerCase();
                        return nameLowerCase === 'epic link' || nameLowerCase === 'gh.epic.link.name';
                    });
                });

                // if epic link is present on server and not selected
                if (epicLinkField && !options.some(function (option) {
                    return option.id === epicLinkField.id;
                })) {
                    otherEpicFields = thiz.selectedServer.columns.filter(function (column) {
                        return column.clauseNames.find(function (name) {
                            var nameLowerCase = name.toLowerCase();
                            return nameLowerCase === 'epic name' || nameLowerCase === 'gh.epic.label.name'
                                || nameLowerCase === 'epic colour' || nameLowerCase === 'gh.epic.color.name'
                                || nameLowerCase === 'epic status' || nameLowerCase === 'gh.epic.status.name';
                        });
                    });
                    // if other epic field is selected
                    if (options.some(function (option) {
                        return otherEpicFields.some(function (field) {
                            return field.id === option.id;
                        });
                    })) {
                        macroInputParams.epicLinkId = epicLinkField.id;
                    }
                }
            } else {
                macroInputParams.columns = this.defaultColumns;
                macroInputParams.columnIds = this.defaultColumnIds;
            }
        }

        var currentRadioValue = AJS.$('input:radio[name=insert-advanced]:checked').val();
        if (currentRadioValue === 'insert-single') {
            macroInputParams.key = selectedIssueKeys.toString();
        } else if (unselectIssueKeys.length == 0) {
            // add param macro for jql when select all checked
            macroInputParams.jqlQuery = this.lastSearch + ' '; // the trailing empty space to invalidate previous cache
        } else if (selectedIssueKeys.length == 1) {
            macroInputParams.jqlQuery = 'key = ' + selectedIssueKeys.toString();
        } else {
            macroInputParams.jqlQuery = 'key in (' + selectedIssueKeys.toString() + ')';
        }

        // CONF-30116
        if (currentRadioValue === 'insert-table') {
            macroInputParams.maximumIssues = AJS.$('#jira-maximum-issues').val();
        }

        return macroInputParams;
    },
    insertLinkFromForm: function () {
        var thiz = this;
        var container = thiz.container;
        var issueResult = AJS.$('input:checkbox[name=jira-issue]', container);
        if (issueResult.length) {
            var selectedIssueCount = AJS.$('input:checkbox[name=jira-issue]:checked', container).length;
            if (selectedIssueCount > 0) {
                thiz.insertLink();
            }
        }
    },
    insertLink: function (_searchPanel) {
        var searchPanel;
        if (_searchPanel && typeof _searchPanel.insertIssueLinkWithParams === 'function') {
            searchPanel = _searchPanel;
        } else {
            searchPanel = this;
        }
        var macroInputParams = searchPanel.getMacroParamsFromUserInput();
        searchPanel.insertIssueLinkWithParams(macroInputParams);
        return true;
    },
    loadMacroParams: function (columnIdsSelected) {
        var macroParams = this.macroParams;
        if (!macroParams) {
            // init new default macro params
            this.checkAndSetDefaultValueMaximumIssues({ defaultVal: 20 });
            this.prepareColumnSelect(columnIdsSelected);
        } else {
            // CONF-30116
            if (!macroParams.maximumIssues) {
                // disable textbox if there is not display table option
                AJS.$('#jira-maximum-issues').prop("disabled", true);
            }

            if (macroParams.count == 'true') {
                AJS.$('#opt-total').prop('checked', true);
            } else {
                AJS.$('#opt-table').prop('checked', true);
                // CONF-30116

                AJS.$('#jira-maximum-issues').prop("disabled", false);
                var maximumIssues = macroParams.maximumIssues || this.DEFAULT_MAX_ISSUES_VAL;
                this.checkAndSetDefaultValueMaximumIssues({ defaultVal: maximumIssues });
            }
            this.prepareColumnSelect(columnIdsSelected);
        }
    },
    selectHandler: function () {
        var cont = this.container;
        var selectedRow = cont.find('tr.selected');
        if (selectedRow.length) {
            selectedRow.unbind('keydown.space').bind('keydown.space', function (e) {
                if (e.which == 32 || e.keyCode == 32) {
                    var inpChk = selectedRow.find('[type=checkbox]');
                    inpChk.trigger('click');
                }
            });
        }
    },
    addDisplayOptionPanel: function () {
        // get content from soy template
        var displayOptsOverlayHtml = Confluence.Templates.ConfluenceJiraPlugin.displayOptsOverlayHtml;
        AJS.$('.jiraSearchResults').after(displayOptsOverlayHtml());
        // Here we need to bind the submit and return false to prevent the user submission.
        AJS.$('#jiraMacroDlg').unbind('submit').on('submit', function (e) {
            return false;
        }
        );
    },
    updateTotalIssuesDisplay: function (totalIssues) {
        var jiraIssuesLink = this.selectedServer.url + '/issues/?jql=' + this.lastSearch;
        // add infor view all
        if (totalIssues > 20) {
            AJS.$('.my-result.aui').after(Confluence.Templates.ConfluenceJiraPlugin.viewAll({ jiraIssuesLink: jiraIssuesLink }));
        }
        // update total issues display
        var totalIssuesText = AJS.I18n.getText('insert.jira.issue.option.count.sample', totalIssues);
        AJS.$('.total-issues-text').html(totalIssuesText);
        // update link for total issues link to jira
        AJS.$('.total-issues-link').attr('href', jiraIssuesLink);
    },
    prepareColumnSelect: function (columnIdsSelected) {
        var thiz = this;
        var isColumIdPresent = !(this.macroParams && !this.macroParams.columnIds);
        var columns = columnIdsSelected // re-open the modal with columns previously selected in the same session
            || (this.macroParams && this.macroParams.columnIds && this.macroParams.columnIds.split(',')) // edit a new macro that contains custom field ids
            || (this.macroParams && this.macroParams.columns && this.macroParams.columns.toLowerCase().split(',')) // edit a legacy macro that doesn't contain custom field ids
            || this.defaultColumnIds.split(','); // create a new macro

        var server = this.selectedServer;
        var initColumnSelect = function (fields) {
            var $columnSelect = AJS.$('#jiraIssueColumnSelector');
            var unselectedOptionHTML = '';
            var selectedOptionHTML = '';
            fields
                .filter(function (field) { return field.navigable; })
                // The reason we need to do this: we need to provide the selected columns in options with appropriate order
                // to select2 component. If we don't do this, it will load the selected columns following the order of
                // columns returned by Jira
                .sort(function (a, b) {
                    var columnsMapped = columns.map(function (column) {
                        var aliasFound = thiz.aliases.find(function (alias) { return alias.clauseName === column; });
                        return aliasFound ? aliasFound.id : column;
                    });
                    return columnsMapped.indexOf((isColumIdPresent || !a.custom) ? a.id : a.name.toLowerCase()) - columnsMapped.indexOf((isColumIdPresent || !b.custom) ? b.id : b.name.toLowerCase());
                })
                .forEach(function (field) {
                    const isColumnSelected = columns.find(function (column) {
                        if (isColumIdPresent) {
                            return column === field.id;
                        }
                        return field.clauseNames.includes(column) || column === field.name.toLowerCase();
                    });

                    // build html option string for selected columns.
                    if (isColumnSelected) {
                        selectedOptionHTML += Confluence.Templates.ConfluenceJiraPlugin.selectableOption({
                            name: field.name,
                            value: field.id,
                            selected: true
                        });

                    // build html string for unselected columns
                    } else {
                        unselectedOptionHTML += Confluence.Templates.ConfluenceJiraPlugin.selectableOption({
                            name: field.name,
                            value: field.id
                        });
                    }
                });

            // Fix for lasted chrome browser. when we add values for multiple select it will make display option panel show
            $columnSelect.hide();
            $columnSelect.html(selectedOptionHTML + unselectedOptionHTML);
            $columnSelect.show();

            $columnSelect.auiSelect2({
                width: '415px',
                containerCssClass: 'select2-container-jira-issue-columns'
            });
            AJS.Editor.JiraConnector.Panel.Search.jiraColumnSelectBox = $columnSelect;
        };

        if (server.columns && server.columns.length > 0) {
            initColumnSelect(server.columns);
            return;
        }
        this.retrieveJson(server.id, '/rest/api/2/field',
            function (data) {
                if (data && data.length) {
                    server.columns = data;
                    initColumnSelect(server.columns);
                }
            });
    },
    expandDisplayOptPanel: function () {
        var displayOptsOverlay = AJS.$('.jql-display-opts-overlay');
        var currentHeighOfOptsOverlay = displayOptsOverlay.height();
        var topMarginDisplayOverlay = 40;
        displayOptsOverlay.css('top', '');
        // here we need to calculate the current bottom position and set
        // to displayOptsOverlay. IF NOT, it does not have the original "from" bottom
        // position to start the animation and it will cause the Flash effect.

        var currentBottomPosition = -(currentHeighOfOptsOverlay - topMarginDisplayOverlay);
        displayOptsOverlay.css('bottom', currentBottomPosition + 'px');
        displayOptsOverlay.animate({
            bottom: 0
        }, 500);
    },
    minimizeDisplayOptPanel: function () {
        var displayOptsOverlay = AJS.$('.jql-display-opts-overlay');
        // Need to get the current top value and set to the displayOptOverlay
        // because it needs the "from" top value to make the animation smoothly
        displayOptsOverlay.css('top', displayOptsOverlay.position().top + 'px');
        displayOptsOverlay.css('bottom', '');
        displayOptsOverlay.animate({
            top: 414
        }, 500);
    },
    disableAutoSelectColumns: function () {
        AJS.Editor.JiraConnector.Panel.Search.jiraColumnSelectBox.auiSelect2('enable', false);
    },
    enableAutoSelectColumns: function () {
        AJS.Editor.JiraConnector.Panel.Search.jiraColumnSelectBox.auiSelect2('enable', true);
    },
    checkAutoSelectColumns: function () {
        if (AJS.$('#opt-table').prop('checked')) {
            this.enableAutoSelectColumns();
        } else {
            this.disableAutoSelectColumns();
            this.enableInsert();
        }
    },
    // bind event for new layout
    bindEventToDisplayOptionPanel: function (acceptNoResult, searchParams) {
        var thiz = this;
        var displayOptsBtn = AJS.$('.jql-display-opts-close, .jql-display-opts-open');


        var displayOptsOverlay = AJS.$('.jql-display-opts-overlay');


        var optDisplayRadios = AJS.$('.jql-display-opts-inner .radio');


        var ticketCheckboxAll = AJS.$('#my-jira-search input:checkbox[name=jira-issue-all]');


        var ticketCheckboxes = AJS.$('#my-jira-search input:checkbox[name=jira-issue]');
        var $maxiumIssues = AJS.$('#jira-maximum-issues');

        // CONF-30116
        $maxiumIssues.on('blur keyup', AJS.Editor.JiraConnector.Panel.Search.prototype.validateMaxIssues);

        displayOptsOverlay.css('top', '414px');

        displayOptsBtn.click(function (e) {
            e.preventDefault();
            if (AJS.$(this).hasClass('disabled')) {
                return;
            }
            var isOpenButton = AJS.$(this).hasClass('jql-display-opts-open');

            if (isOpenButton) {
                thiz.expandDisplayOptPanel();

                jQuery(this).addClass('jql-display-opts-close');
                jQuery(this).removeClass('jql-display-opts-open');
            } else {
                thiz.minimizeDisplayOptPanel();
                jQuery(this).removeClass('jql-display-opts-close');
                jQuery(this).addClass('jql-display-opts-open');
            }
        });
        optDisplayRadios.change(function () {
            thiz.checkAutoSelectColumns();
            thiz.validateMaxIssues();
        });

        ticketCheckboxAll.bind('click', function () {
            var all = AJS.$(this);
            if (all.prop('checked')) {
                ticketCheckboxes.prop('checked', 'checked');
            } else {
                ticketCheckboxes.prop("checked", false);
            }
            thiz.validate();
        });

        ticketCheckboxes.change(function () {
            var ticketUncheckedLength = AJS.$('#my-jira-search input:checkbox[name=jira-issue]:not(:checked)').length;
            if (ticketUncheckedLength > 0) {
                ticketCheckboxAll.prop("checked", false);
            } else {
                ticketCheckboxAll.prop('checked', 'checked');
            }
            thiz.validate();
        });
        thiz.validate(acceptNoResult, searchParams);
    },
    /*
     * Change radio button value base on an action on issue checkboxes
     * */
    changeInsertOptionStatus: function (selectedIssueCount, handleNoRow, searchParams) {
        var thiz = this;
        var radioSingle = AJS.$('#opt-single');
        var radioCount = AJS.$('#opt-total');
        var radioTable = AJS.$('#opt-table');
        var checkboxes = AJS.$('#my-jira-search input:checkbox[name=jira-issue]:checked');
        var isCheckedAll = AJS.$('#my-jira-search input:checkbox[name=jira-issue-all]').prop('checked') === true;
        var isSingleIssueChecked = checkboxes.length === 1;
        var isMultipleIssuesChecked = checkboxes.length > 1;
        var isNothingChecked = checkboxes.length === 0;
        var singleKeyJQL = AJS.JQLHelper.isSingleKeyJQLExp(AJS.$('#my-jira-search input[name=jiraSearch]').val());

        var checkIssueType = function () {
            if (searchParams && searchParams.isJqlQuery) {
                radioTable.click();
            } else {
                radioSingle.click();
            }
        };

        var enableSingleIssueMode = function () {
            radioCount.prop("disabled", true);
            radioTable.prop("disabled", false);
            radioSingle.prop("disabled", false);
            checkIssueType();
            setTimeout(function () {
                checkIssueType();
            }, 100);
        };

        var enableMultipleIssuesMode = function () {
            radioSingle.prop("disabled", true);
            radioCount.prop("disabled", false);
            if (AJS.$('input[name=insert-advanced]:checked').val() === 'insert-single') {
                setTimeout(function () {
                    radioTable.prop("disabled", false).click();
                }, 100);
            }
        };

        var enableAllDisplayOptions = function () {
            radioTable.prop("disabled", false);
            radioCount.prop("disabled", false);
            radioSingle.prop("disabled", false);
            var currentRadioValue = AJS.$('input:radio[name=insert-advanced]:checked').val();
            if (currentRadioValue === 'insert-single') {
                setTimeout(function () {
                    radioTable.click();
                }, 100);
            }
        };

        var disableOptionPanel = function () {
            radioSingle.prop("disabled", true);
            radioCount.prop("disabled", true);
            radioTable.prop("disabled", true);
            AJS.$('.jql-display-opts-close').click();
            AJS.$('.jql-display-opts-open').addClass('disabled');
        };

        AJS.$('.jql-display-opts-open').removeClass('disabled');
        radioSingle.prop("disabled", false);
        radioCount.prop("disabled", false);
        radioTable.prop("disabled", false);

        if (isCheckedAll && isSingleIssueChecked && singleKeyJQL) { // single issue key, for eg: key = wbs-1
            enableSingleIssueMode();
        } else if (isCheckedAll && isSingleIssueChecked && !singleKeyJQL) { // valid jql that returns only 1 result
            enableAllDisplayOptions();
        } else if (isMultipleIssuesChecked) {
            enableMultipleIssuesMode();
        } else if (isSingleIssueChecked && !isCheckedAll) { // single result is check when jql returns multiple result
            enableSingleIssueMode();
        } else if (handleNoRow) {
            enableMultipleIssuesMode();
        } else if (isNothingChecked) {
            disableOptionPanel();
        }
    },

    isInsertTableType: function () {
        return AJS.$('input:radio[name=insert-advanced]:checked').val() === 'insert-table';
    },

    setInsertButtonState: function () {
        var $displayOptsBtn = AJS.$('.jql-display-opts-close, .jql-display-opts-open');
        var $maximumIssue = AJS.$('#jira-maximum-issues');
        if (!$displayOptsBtn.length
            || ($displayOptsBtn.length && this.isInsertTableType() && !this.isValidMaxIssues($maximumIssue.val()))) {
            this.disableInsert();
        } else {
            this.enableInsert();
        }
    },

    analyticPanelActionName: 'confluence.jira.plugin.searchadded'

});
AJS.Editor.JiraConnector.Panels.push(new AJS.Editor.JiraConnector.Panel.Search());
