AJS.toInit(function () {
    var FormStateControl = require('confluence/form-state-control');

    // default image
    // /download/resources/confluence.extra.jira/images/jira-chart-macro-icon.png
    // register chart image load event
    AJS.$(".jira-chart-macro-img").on('load',
        function (event) {
            // Enale the insert button
            AJS.log('Jira Chart Macro - chart image loaded');
            FormStateControl.enableElement(AJS.$('.insert-jira-chart-macro-button', window.parent.document));
        }).on('error',
        function (event) {
            AJS.log('Jira Chart Macro - chart image loaded error');
            FormStateControl.disableElement(AJS.$('.insert-jira-chart-macro-button', window.parent.document));
            var image = AJS.$(event.target);
            var imageWrapper = image.parent();
            var imageContainer = imageWrapper.parent();
            // remove image and show error message
            imageWrapper.remove();
            var erroMsg = AJS.I18n.getText("jirachart.error.execution");
            AJS.messages.error(imageContainer, {
                body: erroMsg
            });
        });
});


