define('confluence-browser-metrics/marshallers/page-end-marshaller', [
    'confluence-browser-metrics/util/is-number'
], function (
    isNumber
) {
    function isPageEndReport(report) {
        return isNumber(report.pageEnd);
    }

    var pageEndMarshaller = function (report) {
        if (isPageEndReport(report)) {
            return { pageEnd: "" + Math.floor( report.pageEnd ) };
        }
    };

    return pageEndMarshaller;

});